var _excluded = ["className", "disabled", "direction", "items", "label", "ariaLabel", "itemToString", "itemToElement", "type", "size", "onChange", "id", "titleText", "hideLabel", "helperText", "translateWithId", "light", "invalid", "invalidText", "warn", "warnText", "initialSelectedItem", "selectedItem", "downshiftProps"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useRef } from 'react';
import { useSelect } from 'downshift';
import cx from 'classnames';
import PropTypes from 'prop-types';
import { Checkmark16, WarningAltFilled16, WarningFilled16 } from '@carbon/icons-react';
import ListBox, { PropTypes as ListBoxPropTypes } from '../ListBox';
import { mapDownshiftProps } from '../../tools/createPropAdapter';
import mergeRefs from '../../tools/mergeRefs';
import deprecate from '../../prop-types/deprecate';
import { useFeatureFlag } from '../FeatureFlags';
import { usePrefix } from '../../internal/usePrefix';

var defaultItemToString = function defaultItemToString(item) {
  if (typeof item === 'string') {
    return item;
  }

  return item ? item.label : '';
};

var Dropdown = /*#__PURE__*/React.forwardRef(function Dropdown(_ref, ref) {
  var _cx, _cx2, _cx4;

  var containerClassName = _ref.className,
      disabled = _ref.disabled,
      direction = _ref.direction,
      items = _ref.items,
      label = _ref.label,
      ariaLabel = _ref.ariaLabel,
      itemToString = _ref.itemToString,
      itemToElement = _ref.itemToElement,
      type = _ref.type,
      size = _ref.size,
      onChange = _ref.onChange,
      id = _ref.id,
      titleText = _ref.titleText,
      hideLabel = _ref.hideLabel,
      helperText = _ref.helperText,
      translateWithId = _ref.translateWithId,
      light = _ref.light,
      invalid = _ref.invalid,
      invalidText = _ref.invalidText,
      warn = _ref.warn,
      warnText = _ref.warnText,
      initialSelectedItem = _ref.initialSelectedItem,
      controlledSelectedItem = _ref.selectedItem,
      downshiftProps = _ref.downshiftProps,
      other = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var selectProps = mapDownshiftProps(_objectSpread(_objectSpread({}, downshiftProps), {}, {
    items: items,
    itemToString: itemToString,
    initialSelectedItem: initialSelectedItem,
    onSelectedItemChange: onSelectedItemChange
  })); // only set selectedItem if the prop is defined. Setting if it is undefined
  // will overwrite default selected items from useSelect

  if (controlledSelectedItem !== undefined) {
    selectProps.selectedItem = controlledSelectedItem;
  }

  var _useSelect = useSelect(selectProps),
      isOpen = _useSelect.isOpen,
      getToggleButtonProps = _useSelect.getToggleButtonProps,
      getLabelProps = _useSelect.getLabelProps,
      getMenuProps = _useSelect.getMenuProps,
      getItemProps = _useSelect.getItemProps,
      highlightedIndex = _useSelect.highlightedIndex,
      selectedItem = _useSelect.selectedItem;

  var inline = type === 'inline';
  var showWarning = !invalid && warn;
  var enabled = useFeatureFlag('enable-v11-release');
  var className = cx("".concat(prefix, "--dropdown"), [enabled ? null : containerClassName], (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--dropdown--invalid"), invalid), _defineProperty(_cx, "".concat(prefix, "--dropdown--warning"), showWarning), _defineProperty(_cx, "".concat(prefix, "--dropdown--open"), isOpen), _defineProperty(_cx, "".concat(prefix, "--dropdown--inline"), inline), _defineProperty(_cx, "".concat(prefix, "--dropdown--disabled"), disabled), _defineProperty(_cx, "".concat(prefix, "--dropdown--light"), light), _defineProperty(_cx, "".concat(prefix, "--dropdown--").concat(size), size), _defineProperty(_cx, "".concat(prefix, "--list-box--up"), direction === 'top'), _cx));
  var titleClasses = cx("".concat(prefix, "--label"), (_cx2 = {}, _defineProperty(_cx2, "".concat(prefix, "--label--disabled"), disabled), _defineProperty(_cx2, "".concat(prefix, "--visually-hidden"), hideLabel), _cx2));
  var helperClasses = cx("".concat(prefix, "--form__helper-text"), _defineProperty({}, "".concat(prefix, "--form__helper-text--disabled"), disabled));
  var wrapperClasses = cx("".concat(prefix, "--dropdown__wrapper"), "".concat(prefix, "--list-box__wrapper"), [enabled ? containerClassName : null], (_cx4 = {}, _defineProperty(_cx4, "".concat(prefix, "--dropdown__wrapper--inline"), inline), _defineProperty(_cx4, "".concat(prefix, "--list-box__wrapper--inline"), inline), _defineProperty(_cx4, "".concat(prefix, "--dropdown__wrapper--inline--invalid"), inline && invalid), _defineProperty(_cx4, "".concat(prefix, "--list-box__wrapper--inline--invalid"), inline && invalid), _cx4)); // needs to be Capitalized for react to render it correctly

  var ItemToElement = itemToElement;
  var toggleButtonProps = getToggleButtonProps();
  var helper = helperText ? /*#__PURE__*/React.createElement("div", {
    className: helperClasses
  }, helperText) : null;

  function onSelectedItemChange(_ref2) {
    var selectedItem = _ref2.selectedItem;

    if (onChange) {
      onChange({
        selectedItem: selectedItem
      });
    }
  }

  var menuItemOptionRefs = useRef(items.map(function (_) {
    return /*#__PURE__*/React.createRef();
  }));
  return /*#__PURE__*/React.createElement("div", _extends({
    className: wrapperClasses
  }, other), titleText && /*#__PURE__*/React.createElement("label", _extends({
    className: titleClasses
  }, getLabelProps()), titleText), /*#__PURE__*/React.createElement(ListBox, {
    "aria-label": ariaLabel,
    size: size,
    className: className,
    invalid: invalid,
    invalidText: invalidText,
    warn: warn,
    warnText: warnText,
    light: light,
    isOpen: isOpen,
    id: id
  }, invalid && /*#__PURE__*/React.createElement(WarningFilled16, {
    className: "".concat(prefix, "--list-box__invalid-icon")
  }), showWarning && /*#__PURE__*/React.createElement(WarningAltFilled16, {
    className: "".concat(prefix, "--list-box__invalid-icon ").concat(prefix, "--list-box__invalid-icon--warning")
  }), /*#__PURE__*/React.createElement("button", _extends({
    type: "button",
    className: "".concat(prefix, "--list-box__field"),
    disabled: disabled,
    "aria-disabled": disabled,
    title: selectedItem ? itemToString(selectedItem) : label
  }, toggleButtonProps, {
    ref: mergeRefs(toggleButtonProps.ref, ref)
  }), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--list-box__label")
  }, selectedItem ? itemToString(selectedItem) : label), /*#__PURE__*/React.createElement(ListBox.MenuIcon, {
    isOpen: isOpen,
    translateWithId: translateWithId
  })), /*#__PURE__*/React.createElement(ListBox.Menu, getMenuProps(), isOpen && items.map(function (item, index) {
    var _menuItemOptionRefs$c;

    var itemProps = getItemProps({
      item: item,
      index: index
    });
    var title = itemToElement ? item.text : itemToString(item);

    var _ref3 = (menuItemOptionRefs === null || menuItemOptionRefs === void 0 ? void 0 : (_menuItemOptionRefs$c = menuItemOptionRefs.current[index]) === null || _menuItemOptionRefs$c === void 0 ? void 0 : _menuItemOptionRefs$c.current) || {},
        offsetWidth = _ref3.offsetWidth,
        scrollWidth = _ref3.scrollWidth;

    return /*#__PURE__*/React.createElement(ListBox.MenuItem, _extends({
      key: itemProps.id,
      isActive: selectedItem === item,
      isHighlighted: highlightedIndex === index || selectedItem === item,
      title: offsetWidth < scrollWidth && title || undefined,
      ref: {
        menuItemOptionRef: menuItemOptionRefs.current[index]
      }
    }, itemProps), itemToElement ? /*#__PURE__*/React.createElement(ItemToElement, _extends({
      key: itemProps.id
    }, item)) : itemToString(item), selectedItem === item && /*#__PURE__*/React.createElement(Checkmark16, {
      className: "".concat(prefix, "--list-box__menu-item__selected-icon")
    }));
  }))), !inline && !invalid && !warn && helper);
});
Dropdown.displayName = 'Dropdown';
Dropdown.propTypes = {
  /**
   * 'aria-label' of the ListBox component.
   */
  ariaLabel: PropTypes.string,

  /**
   * Provide a custom className to be applied on the bx--dropdown node
   */
  className: PropTypes.string,

  /**
   * Specify the direction of the dropdown. Can be either top or bottom.
   */
  direction: PropTypes.oneOf(['top', 'bottom']),

  /**
   * Disable the control
   */
  disabled: PropTypes.bool,

  /**
   * Additional props passed to Downshift
   */
  downshiftProps: PropTypes.object,

  /**
   * Provide helper text that is used alongside the control label for
   * additional help
   */
  helperText: PropTypes.oneOfType([PropTypes.string, PropTypes.node]),

  /**
   * Specify whether the title text should be hidden or not
   */
  hideLabel: PropTypes.bool,

  /**
   * Specify a custom `id`
   */
  id: PropTypes.string.isRequired,

  /**
   * Allow users to pass in an arbitrary item or a string (in case their items are an array of strings)
   * from their collection that are pre-selected
   */
  initialSelectedItem: PropTypes.oneOfType([PropTypes.object, PropTypes.string, PropTypes.number]),

  /**
   * Specify whether you want the inline version of this control
   */
  inline: deprecate(PropTypes.bool, "The `inline` prop has been deprecated and will\n    be removed in the next major release. To specify the inline variant of Dropdown, please use the `type` prop."),

  /**
   * Specify if the currently selected value is invalid.
   */
  invalid: PropTypes.bool,

  /**
   * Message which is displayed if the value is invalid.
   */
  invalidText: PropTypes.node,

  /**
   * Function to render items as custom components instead of strings.
   * Defaults to null and is overridden by a getter
   */
  itemToElement: PropTypes.func,

  /**
   * Helper function passed to downshift that allows the library to render a
   * given item to a string label. By default, it extracts the `label` field
   * from a given item to serve as the item label in the list.
   */
  itemToString: PropTypes.func,

  /**
   * We try to stay as generic as possible here to allow individuals to pass
   * in a collection of whatever kind of data structure they prefer
   */
  items: PropTypes.array.isRequired,

  /**
   * Generic `label` that will be used as the textual representation of what
   * this field is for
   */
  label: PropTypes.node.isRequired,

  /**
   * `true` to use the light version.
   */
  light: PropTypes.bool,

  /**
   * `onChange` is a utility for this controlled component to communicate to a
   * consuming component what kind of internal state changes are occurring.
   */
  onChange: PropTypes.func,

  /**
   * In the case you want to control the dropdown selection entirely.
   */
  selectedItem: PropTypes.oneOfType([PropTypes.object, PropTypes.string, PropTypes.number]),

  /**
   * Specify the size of the ListBox. Currently supports either `sm`, `md` or `lg` as an option.
   */
  size: ListBoxPropTypes.ListBoxSize,

  /**
   * Provide the title text that will be read by a screen reader when
   * visiting this control
   */
  titleText: PropTypes.node,

  /**
   * Callback function for translating ListBoxMenuIcon SVG title
   */
  translateWithId: PropTypes.func,

  /**
   * The dropdown type, `default` or `inline`
   */
  type: ListBoxPropTypes.ListBoxType,

  /**
   * Specify whether the control is currently in warning state
   */
  warn: PropTypes.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: PropTypes.node
};
Dropdown.defaultProps = {
  disabled: false,
  type: 'default',
  itemToString: defaultItemToString,
  itemToElement: null,
  light: false,
  titleText: '',
  helperText: '',
  direction: 'bottom'
};
export default Dropdown;