function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright IBM Corp. 2015, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { FeatureFlags as GlobalFeatureFlags, createScope } from '@carbon/feature-flags';
import PropTypes from 'prop-types';
import React, { createContext, useContext, useEffect, useRef, useState } from 'react';
/**
 * Our FeatureFlagContext is used alongside the FeatureFlags component to enable
 * or disable feature flags in a given React tree
 */

var FeatureFlagContext = /*#__PURE__*/createContext(GlobalFeatureFlags);
/**
 * Supports an object of feature flag values with the `flags` prop, merging them
 * along with the current `FeatureFlagContext` to provide consumers to check if
 * a feature flag is enabled or disabled in a given React tree
 */

function FeatureFlags(_ref) {
  var children = _ref.children,
      _ref$flags = _ref.flags,
      flags = _ref$flags === void 0 ? {} : _ref$flags;
  var parentScope = useContext(FeatureFlagContext);

  var _useState = useState(parentScope),
      _useState2 = _slicedToArray(_useState, 2),
      prevParentScope = _useState2[0],
      setPrevParentScope = _useState2[1];

  var _useState3 = useState(function () {
    var scope = createScope(flags);
    scope.mergeWithScope(parentScope);
    return scope;
  }),
      _useState4 = _slicedToArray(_useState3, 2),
      scope = _useState4[0],
      updateScope = _useState4[1];

  if (parentScope !== prevParentScope) {
    var _scope = createScope(flags);

    _scope.mergeWithScope(parentScope);

    updateScope(_scope);
    setPrevParentScope(parentScope);
  } // We use a custom hook to detect if any of the keys or their values change
  // for flags that are passed in. If they have changed, then we re-create the
  // FeatureFlagScope using the new flags


  useChangedValue(flags, isEqual, function (changedFlags) {
    var scope = createScope(changedFlags);
    scope.mergeWithScope(parentScope);
    updateScope(scope);
  });
  return /*#__PURE__*/React.createElement(FeatureFlagContext.Provider, {
    value: scope
  }, children);
}

FeatureFlags.propTypes = {
  children: PropTypes.node,

  /**
   * Provide the feature flags to enabled or disabled in the current React tree
   */
  flags: PropTypes.objectOf(PropTypes.bool)
};
/**
 * This hook will store previous versions of the given `value` and compare the
 * current value to the previous one using the `compare` function. If the
 * compare function returns true, then the given `callback` is invoked in an
 * effect.
 *
 * @param {any} value
 * @param {Function} compare
 * @param {Function} callback
 */

function useChangedValue(value, compare, callback) {
  var initialRender = useRef(false);
  var savedCallback = useRef(callback);

  var _useState5 = useState(value),
      _useState6 = _slicedToArray(_useState5, 2),
      prevValue = _useState6[0],
      setPrevValue = _useState6[1];

  if (!compare(prevValue, value)) {
    setPrevValue(value);
  }

  useEffect(function () {
    savedCallback.current = callback;
  });
  useEffect(function () {
    // We only want the callback triggered after the first render
    if (initialRender.current) {
      savedCallback.current(prevValue);
    }
  }, [prevValue]);
  useEffect(function () {
    initialRender.current = true;
  }, []);
}
/**
 * Access whether a given flag is enabled or disabled in a given
 * FeatureFlagContext
 *
 * @returns {boolean}
 */


function useFeatureFlag(flag) {
  var scope = useContext(FeatureFlagContext);
  return scope.enabled(flag);
}
/**
 * Access all feature flag information for the given FeatureFlagContext
 *
 * @returns {FeatureFlagScope}
 */


function useFeatureFlags() {
  return useContext(FeatureFlagContext);
}
/**
 * Compare two objects and determine if they are equal. This is a shallow
 * comparison since the objects we are comparing are objects with boolean flags
 * from the flags prop in the `FeatureFlags` component
 *
 * @param {object} a
 * @param {object} b
 * @returns {boolean}
 */


function isEqual(a, b) {
  if (a === b) {
    return true;
  }

  for (var _i2 = 0, _Object$keys = Object.keys(a); _i2 < _Object$keys.length; _i2++) {
    var key = _Object$keys[_i2];

    if (a[key] !== b[key]) {
      return false;
    }
  }

  for (var _i3 = 0, _Object$keys2 = Object.keys(b); _i3 < _Object$keys2.length; _i3++) {
    var _key = _Object$keys2[_i3];

    if (b[_key] !== a[_key]) {
      return false;
    }
  }

  return true;
}

export { FeatureFlags, FeatureFlagContext, useFeatureFlags, useFeatureFlag };