var _excluded = ["as", "children", "initialFocusRef"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import * as React from 'react';
import { useMergedRefs } from '../../internal/useMergedRefs';
import { useAutoFocus } from './useAutoFocus';
import { useFocusScope } from './useFocusScope';
import { useRestoreFocus } from './useRestoreFocus';
var FocusScope = /*#__PURE__*/React.forwardRef(function FocusScope(props, forwardRef) {
  var _props$as = props.as,
      BaseComponent = _props$as === void 0 ? 'div' : _props$as,
      children = props.children,
      initialFocusRef = props.initialFocusRef,
      rest = _objectWithoutProperties(props, _excluded);

  var containerRef = React.useRef(null);
  var focusScope = useFocusScope(containerRef);
  var ref = useMergedRefs([forwardRef, containerRef]);
  useRestoreFocus(containerRef);
  useAutoFocus(function () {
    if (initialFocusRef) {
      return initialFocusRef;
    }

    return focusScope.current.getFirstDescendant();
  });
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FocusScopeBumper, {
    onFocus: function onFocus() {
      focusScope.current.focusLastDescendant();
    }
  }), /*#__PURE__*/React.createElement(BaseComponent, _extends({}, rest, {
    ref: ref
  }), children), /*#__PURE__*/React.createElement(FocusScopeBumper, {
    onFocus: function onFocus() {
      focusScope.current.focusFirstDescendant();
    }
  }));
});

if (process.env.NODE_ENV !== "production") {
  FocusScope.displayName = 'FocusScope';
}

FocusScope.propTypes = {
  /**
   * Provide a custom element type for the containing element
   */
  as: PropTypes.oneOfType([PropTypes.func, PropTypes.string, PropTypes.elementType]),

  /**
   * Provide the children to be rendered inside of the `FocusScope`
   */
  children: PropTypes.node,

  /**
   * Provide a `ref` that is used to place focus when the `FocusScope` is
   * initially opened
   */
  initialFocusRef: PropTypes.shape({
    current: PropTypes.any
  })
};
var bumperStyle = {
  outline: 'none',
  opacity: '0',
  position: 'fixed',
  pointerEvents: 'none'
};

function FocusScopeBumper(props) {
  return /*#__PURE__*/React.createElement("span", _extends({
    "data-carbon-focus-scope": "",
    style: bumperStyle // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
    ,
    tabIndex: "0"
  }, props));
}

export { FocusScope };