var _excluded = ["legendId", "legendText", "invalid", "children", "className", "message", "messageText", "hasMargin"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import classnames from 'classnames';
import { useFeatureFlag } from '../FeatureFlags';
import { usePrefix } from '../../internal/usePrefix';

var FormGroup = function FormGroup(_ref) {
  var legendId = _ref.legendId,
      legendText = _ref.legendText,
      invalid = _ref.invalid,
      children = _ref.children,
      className = _ref.className,
      message = _ref.message,
      messageText = _ref.messageText,
      hasMargin = _ref.hasMargin,
      other = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var enabled = useFeatureFlag('enable-v11-release');
  var classNamesLegend = classnames("".concat(prefix, "--label"), [enabled ? null : className]);
  var classNamesFieldset = classnames("".concat(prefix, "--fieldset"), className, _defineProperty({}, "".concat(prefix, "--fieldset--no-margin"), !hasMargin));
  return /*#__PURE__*/React.createElement("fieldset", _extends({}, invalid && {
    'data-invalid': ''
  }, {
    className: classNamesFieldset
  }, other, {
    "aria-labelledby": other['aria-labelledby'] || legendId
  }), /*#__PURE__*/React.createElement("legend", {
    className: classNamesLegend,
    id: legendId || other['aria-labelledby']
  }, legendText), children, message ? /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--form__requirements")
  }, messageText) : null);
};

FormGroup.propTypes = {
  /**
   * Provide the children form elements to be rendered inside of the <fieldset>
   */
  children: PropTypes.node,

  /**
   * Provide a custom className to be applied to the containing <fieldset> node
   */
  className: PropTypes.string,

  /**
   * Specify whether or not the FormGroup should provide bottom margin
   */
  hasMargin: PropTypes.bool,

  /**
   * Specify whether the <FormGroup> is invalid
   */
  invalid: PropTypes.bool,

  /**
   * Provide id for the fieldset <legend> which corresponds to the fieldset
   * `aria-labelledby`
   */
  legendId: PropTypes.node,

  /**
   * Provide the text to be rendered inside of the fieldset <legend>
   */
  legendText: PropTypes.node.isRequired,

  /**
   * Specify whether the message should be displayed in the <FormGroup>
   */
  message: PropTypes.bool,

  /**
   * Provide the text for the message in the <FormGroup>
   */
  messageText: PropTypes.string
};
FormGroup.defaultProps = {
  invalid: false,
  message: false,
  messageText: '',
  hasMargin: true
};
export default FormGroup;