var _excluded = ["as", "children"];

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
var HeadingContext = /*#__PURE__*/React.createContext(1);

function Section(_ref) {
  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'section' : _ref$as,
      children = _ref.children,
      rest = _objectWithoutProperties(_ref, _excluded);

  var level = React.useContext(HeadingContext);
  return /*#__PURE__*/React.createElement(HeadingContext.Provider, {
    value: Math.min(level + 1, 6)
  }, /*#__PURE__*/React.createElement(BaseComponent, rest, children));
}

Section.propTypes = {
  /**
   * Provide an alternative tag or component to use instead of the default
   * <section> element
   */
  as: PropTypes.elementType,

  /**
   * Specify the content that will be placed in the component
   */
  children: PropTypes.node,

  /**
   * Specify a class name for the outermost node of the component
   */
  className: PropTypes.string
};

function Heading(props) {
  var level = React.useContext(HeadingContext);
  return /*#__PURE__*/React.createElement("h".concat(level), props);
}

Heading.propTypes = {
  /**
   * Specify the content that will be placed in the component
   */
  children: PropTypes.node,

  /**
   * Specify a class name for the outermost node of the component
   */
  className: PropTypes.string
};
export { Section, Heading };