var _excluded = ["as", "children", "dir"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import { LayoutDirectionContext } from './LayoutDirectionContext';

function LayoutDirection(_ref) {
  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'div' : _ref$as,
      children = _ref.children,
      dir = _ref.dir,
      rest = _objectWithoutProperties(_ref, _excluded);

  var value = React.useMemo(function () {
    return {
      direction: dir
    };
  }, [dir]);
  return /*#__PURE__*/React.createElement(LayoutDirectionContext.Provider, {
    value: value
  }, /*#__PURE__*/React.createElement(BaseComponent, _extends({
    dir: dir
  }, rest), children));
}

LayoutDirection.propTypes = {
  /**
   * Customize the element type used to render the outermost node
   */
  as: PropTypes.oneOfType([PropTypes.func, PropTypes.string, PropTypes.elementType]),

  /**
   * Provide child elements or components to be rendered inside of this
   * component
   */
  children: PropTypes.node,

  /**
   * Specify the layout direction of this part of the page
   */
  dir: PropTypes.oneOf(['ltr', 'rtl']).isRequired
};
export { LayoutDirectionContext, LayoutDirection };