var _excluded = ["children", "isActive", "isHighlighted", "title"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import React, { useEffect, useRef, useState } from 'react';
import PropTypes from 'prop-types';
import { settings } from 'carbon-components';
var prefix = settings.prefix;

function useIsTruncated(ref) {
  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isTruncated = _useState2[0],
      setIsTruncated = _useState2[1];

  useEffect(function () {
    var _ref$current = ref.current,
        offsetWidth = _ref$current.offsetWidth,
        scrollWidth = _ref$current.scrollWidth;
    setIsTruncated(offsetWidth < scrollWidth);
  }, [ref, setIsTruncated]);
  return isTruncated;
}
/**
 * `ListBoxMenuItem` is a helper component for managing the container class
 * name, alongside any classes for any corresponding states, for a generic list
 * box menu item.
 */


var ListBoxMenuItem = /*#__PURE__*/React.forwardRef(function ListBoxMenuItem(_ref, forwardedRef) {
  var _cx;

  var children = _ref.children,
      isActive = _ref.isActive,
      isHighlighted = _ref.isHighlighted,
      title = _ref.title,
      rest = _objectWithoutProperties(_ref, _excluded);

  var ref = useRef(null);
  var isTruncated = useIsTruncated((forwardedRef === null || forwardedRef === void 0 ? void 0 : forwardedRef.menuItemOptionRef) || ref);
  var className = cx("".concat(prefix, "--list-box__menu-item"), (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--list-box__menu-item--active"), isActive), _defineProperty(_cx, "".concat(prefix, "--list-box__menu-item--highlighted"), isHighlighted), _cx));
  return /*#__PURE__*/React.createElement("div", _extends({}, rest, {
    className: className,
    title: isTruncated ? title : undefined
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--list-box__menu-item__option"),
    ref: (forwardedRef === null || forwardedRef === void 0 ? void 0 : forwardedRef.menuItemOptionRef) || ref
  }, children));
});
ListBoxMenuItem.displayName = 'ListBoxMenuItem';
ListBoxMenuItem.propTypes = {
  /**
   * Specify any children nodes that should be rendered inside of the ListBox
   * Menu Item
   */
  children: PropTypes.node,

  /**
   * Specify whether the current menu item is "active".
   */
  isActive: PropTypes.bool.isRequired,

  /**
   * Specify whether the current menu item is "highlighted".
   */
  isHighlighted: PropTypes.bool.isRequired,

  /**
   * Provide an optional tooltip for the ListBoxMenuItem
   */
  title: PropTypes.string
};
ListBoxMenuItem.defaultProps = {
  isActive: false,
  isHighlighted: false
};
export default ListBoxMenuItem;