function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

var _defineProperty2;

var _excluded = ["modalHeading", "modalLabel", "modalAriaLabel", "passiveModal", "hasForm", "secondaryButtonText", "primaryButtonText", "open", "onRequestClose", "onRequestSubmit", "onSecondarySubmit", "iconDescription", "primaryButtonDisabled", "danger", "alert", "secondaryButtons", "selectorPrimaryFocus", "selectorsFloatingMenus", "shouldSubmitOnEnter", "size", "hasScrollingContent", "preventCloseOnClickOutside"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React, { Component } from 'react';
import classNames from 'classnames';
import { settings } from 'carbon-components';
import { Close20 } from '@carbon/icons-react';
import toggleClass from '../../tools/toggleClass';
import Button from '../Button';
import ButtonSet from '../ButtonSet';
import deprecate from '../../prop-types/deprecate';
import requiredIfGivenPropIsTruthy from '../../prop-types/requiredIfGivenPropIsTruthy';
import wrapFocus, { elementOrParentIsFloatingMenu } from '../../internal/wrapFocus';
import setupGetInstanceId from '../../tools/setupGetInstanceId';
var prefix = settings.prefix;
var getInstanceId = setupGetInstanceId();

var Modal = /*#__PURE__*/function (_Component) {
  _inherits(Modal, _Component);

  var _super = _createSuper(Modal);

  function Modal() {
    var _this;

    _classCallCheck(this, Modal);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "button", /*#__PURE__*/React.createRef());

    _defineProperty(_assertThisInitialized(_this), "secondaryButton", /*#__PURE__*/React.createRef());

    _defineProperty(_assertThisInitialized(_this), "outerModal", /*#__PURE__*/React.createRef());

    _defineProperty(_assertThisInitialized(_this), "innerModal", /*#__PURE__*/React.createRef());

    _defineProperty(_assertThisInitialized(_this), "startTrap", /*#__PURE__*/React.createRef());

    _defineProperty(_assertThisInitialized(_this), "endTrap", /*#__PURE__*/React.createRef());

    _defineProperty(_assertThisInitialized(_this), "modalInstanceId", "modal-".concat(getInstanceId()));

    _defineProperty(_assertThisInitialized(_this), "modalLabelId", "".concat(prefix, "--modal-header__label--").concat(_this.modalInstanceId));

    _defineProperty(_assertThisInitialized(_this), "modalHeadingId", "".concat(prefix, "--modal-header__heading--").concat(_this.modalInstanceId));

    _defineProperty(_assertThisInitialized(_this), "modalBodyId", "".concat(prefix, "--modal-body--").concat(_this.modalInstanceId));

    _defineProperty(_assertThisInitialized(_this), "modalCloseButtonClass", "".concat(prefix, "--modal-close"));

    _defineProperty(_assertThisInitialized(_this), "isCloseButton", function (element) {
      return !_this.props.onSecondarySubmit && element === _this.secondaryButton.current || element.classList.contains(_this.modalCloseButtonClass);
    });

    _defineProperty(_assertThisInitialized(_this), "handleKeyDown", function (evt) {
      if (_this.props.open) {
        if (evt.which === 27) {
          _this.props.onRequestClose(evt);
        }

        if (evt.which === 13 && _this.props.shouldSubmitOnEnter && !_this.isCloseButton(evt.target)) {
          _this.props.onRequestSubmit(evt);
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleMousedown", function (evt) {
      if (_this.innerModal.current && !_this.innerModal.current.contains(evt.target) && !elementOrParentIsFloatingMenu(evt.target, _this.props.selectorsFloatingMenus) && !_this.props.preventCloseOnClickOutside) {
        _this.props.onRequestClose(evt);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleBlur", function (_ref) {
      var oldActiveNode = _ref.target,
          currentActiveNode = _ref.relatedTarget;
      var _this$props = _this.props,
          open = _this$props.open,
          selectorsFloatingMenus = _this$props.selectorsFloatingMenus;

      if (open && currentActiveNode && oldActiveNode) {
        var bodyNode = _this.innerModal.current;
        var startTrapNode = _this.startTrap.current;
        var endTrapNode = _this.endTrap.current;
        wrapFocus({
          bodyNode: bodyNode,
          startTrapNode: startTrapNode,
          endTrapNode: endTrapNode,
          currentActiveNode: currentActiveNode,
          oldActiveNode: oldActiveNode,
          selectorsFloatingMenus: selectorsFloatingMenus
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "initialFocus", function (focusContainerElement) {
      var containerElement = focusContainerElement || _this.innerModal.current;
      var primaryFocusElement = containerElement ? containerElement.querySelector(_this.props.selectorPrimaryFocus) : null;

      if (primaryFocusElement) {
        return primaryFocusElement;
      }

      return _this.button && _this.button.current;
    });

    _defineProperty(_assertThisInitialized(_this), "focusButton", function (focusContainerElement) {
      var target = _this.initialFocus(focusContainerElement);

      if (target) {
        target.focus();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleTransitionEnd", function (evt) {
      if (evt.target === evt.currentTarget && // Not to handle `onTransitionEnd` on child DOM nodes
      _this.outerModal.current && _this.outerModal.current.offsetWidth && _this.outerModal.current.offsetHeight && _this.beingOpen) {
        _this.focusButton(evt.currentTarget);

        _this.beingOpen = false;
      }
    });

    return _this;
  }

  _createClass(Modal, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (!prevProps.open && this.props.open) {
        this.beingOpen = true;
      } else if (prevProps.open && !this.props.open) {
        this.beingOpen = false;
      }

      toggleClass(document.body, "".concat(prefix, "--body--with-modal-open"), this.props.open);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      toggleClass(document.body, "".concat(prefix, "--body--with-modal-open"), false);
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      toggleClass(document.body, "".concat(prefix, "--body--with-modal-open"), this.props.open);

      if (!this.props.open) {
        return;
      }

      this.focusButton(this.innerModal.current);
    }
  }, {
    key: "render",
    value: function render() {
      var _classNames,
          _classNames3,
          _this2 = this;

      var _this$props2 = this.props,
          modalHeading = _this$props2.modalHeading,
          modalLabel = _this$props2.modalLabel,
          modalAriaLabel = _this$props2.modalAriaLabel,
          passiveModal = _this$props2.passiveModal,
          hasForm = _this$props2.hasForm,
          secondaryButtonText = _this$props2.secondaryButtonText,
          primaryButtonText = _this$props2.primaryButtonText,
          open = _this$props2.open,
          onRequestClose = _this$props2.onRequestClose,
          onRequestSubmit = _this$props2.onRequestSubmit,
          onSecondarySubmit = _this$props2.onSecondarySubmit,
          iconDescription = _this$props2.iconDescription,
          primaryButtonDisabled = _this$props2.primaryButtonDisabled,
          danger = _this$props2.danger,
          alert = _this$props2.alert,
          secondaryButtons = _this$props2.secondaryButtons,
          selectorPrimaryFocus = _this$props2.selectorPrimaryFocus,
          selectorsFloatingMenus = _this$props2.selectorsFloatingMenus,
          shouldSubmitOnEnter = _this$props2.shouldSubmitOnEnter,
          size = _this$props2.size,
          hasScrollingContent = _this$props2.hasScrollingContent,
          preventCloseOnClickOutside = _this$props2.preventCloseOnClickOutside,
          other = _objectWithoutProperties(_this$props2, _excluded);

      var onSecondaryButtonClick = onSecondarySubmit ? onSecondarySubmit : onRequestClose;
      var modalClasses = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--modal"), true), _defineProperty(_classNames, "".concat(prefix, "--modal-tall"), !passiveModal), _defineProperty(_classNames, 'is-visible', open), _defineProperty(_classNames, "".concat(prefix, "--modal--danger"), this.props.danger), _defineProperty(_classNames, this.props.className, this.props.className), _classNames));
      var containerClasses = classNames("".concat(prefix, "--modal-container"), _defineProperty({}, "".concat(prefix, "--modal-container--").concat(size), size));
      var contentClasses = classNames("".concat(prefix, "--modal-content"), (_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix, "--modal-content--with-form"), hasForm), _defineProperty(_classNames3, "".concat(prefix, "--modal-scroll-content"), hasScrollingContent), _classNames3));
      var footerClasses = classNames("".concat(prefix, "--modal-footer"), _defineProperty({}, "".concat(prefix, "--modal-footer--three-button"), Array.isArray(secondaryButtons) && secondaryButtons.length === 2));
      var modalButton = /*#__PURE__*/React.createElement("button", {
        className: this.modalCloseButtonClass,
        type: "button",
        onClick: onRequestClose,
        title: iconDescription,
        "aria-label": iconDescription,
        ref: this.button
      }, /*#__PURE__*/React.createElement(Close20, {
        "aria-label": iconDescription,
        className: "".concat(this.modalCloseButtonClass, "__icon")
      }));
      var ariaLabel = modalLabel || this.props['aria-label'] || modalAriaLabel || modalHeading;
      var getAriaLabelledBy = modalLabel ? this.modalLabelId : this.modalHeadingId;
      var hasScrollingContentProps = hasScrollingContent ? {
        tabIndex: 0,
        role: 'region',
        'aria-label': ariaLabel,
        'aria-labelledby': getAriaLabelledBy
      } : {};
      var alertDialogProps = {};

      if (alert && passiveModal) {
        alertDialogProps.role = 'alert';
      }

      if (alert && !passiveModal) {
        alertDialogProps.role = 'alertdialog';
        alertDialogProps['aria-describedby'] = this.modalBodyId;
      }

      var SecondaryButtonSet = function SecondaryButtonSet() {
        if (Array.isArray(secondaryButtons) && secondaryButtons.length <= 2) {
          return secondaryButtons.map(function (_ref2, i) {
            var buttonText = _ref2.buttonText,
                onButtonClick = _ref2.onClick;
            return /*#__PURE__*/React.createElement(Button, {
              key: "".concat(buttonText, "-").concat(i),
              kind: "secondary",
              onClick: onButtonClick
            }, buttonText);
          });
        }

        if (secondaryButtonText) {
          return /*#__PURE__*/React.createElement(Button, {
            kind: "secondary",
            onClick: onSecondaryButtonClick,
            ref: _this2.secondaryButton
          }, secondaryButtonText);
        }

        return null;
      };

      var modalBody = /*#__PURE__*/React.createElement("div", _extends({
        ref: this.innerModal,
        role: "dialog"
      }, alertDialogProps, {
        className: containerClasses,
        "aria-label": ariaLabel,
        "aria-modal": "true",
        tabIndex: "-1"
      }), /*#__PURE__*/React.createElement("div", {
        className: "".concat(prefix, "--modal-header")
      }, passiveModal && modalButton, modalLabel && /*#__PURE__*/React.createElement("h2", {
        id: this.modalLabelId,
        className: "".concat(prefix, "--modal-header__label")
      }, modalLabel), /*#__PURE__*/React.createElement("h3", {
        id: this.modalHeadingId,
        className: "".concat(prefix, "--modal-header__heading")
      }, modalHeading), !passiveModal && modalButton), /*#__PURE__*/React.createElement("div", _extends({
        id: this.modalBodyId,
        className: contentClasses
      }, hasScrollingContentProps, {
        "aria-labelledby": getAriaLabelledBy
      }), this.props.children), hasScrollingContent && /*#__PURE__*/React.createElement("div", {
        className: "".concat(prefix, "--modal-content--overflow-indicator")
      }), !passiveModal && /*#__PURE__*/React.createElement(ButtonSet, {
        className: footerClasses
      }, /*#__PURE__*/React.createElement(SecondaryButtonSet, null), /*#__PURE__*/React.createElement(Button, {
        kind: danger ? 'danger' : 'primary',
        disabled: primaryButtonDisabled,
        onClick: onRequestSubmit,
        ref: this.button
      }, primaryButtonText)));
      return /*#__PURE__*/React.createElement("div", _extends({}, other, {
        onKeyDown: this.handleKeyDown,
        onMouseDown: this.handleMousedown,
        onBlur: this.handleBlur,
        className: modalClasses,
        role: "presentation",
        onTransitionEnd: this.props.open ? this.handleTransitionEnd : undefined,
        ref: this.outerModal
      }), /*#__PURE__*/React.createElement("span", {
        ref: this.startTrap,
        tabIndex: "0",
        role: "link",
        className: "".concat(prefix, "--visually-hidden")
      }, "Focus sentinel"), modalBody, /*#__PURE__*/React.createElement("span", {
        ref: this.endTrap,
        tabIndex: "0",
        role: "link",
        className: "".concat(prefix, "--visually-hidden")
      }, "Focus sentinel"));
    }
  }]);

  return Modal;
}(Component);

_defineProperty(Modal, "propTypes", (_defineProperty2 = {
  /**
   * Specify whether the Modal is displaying an alert, error or warning
   * Should go hand in hand with the danger prop.
   */
  alert: PropTypes.bool
}, _defineProperty(_defineProperty2, 'aria-label', requiredIfGivenPropIsTruthy('hasScrollingContent', PropTypes.string)), _defineProperty(_defineProperty2, "children", PropTypes.node), _defineProperty(_defineProperty2, "className", PropTypes.string), _defineProperty(_defineProperty2, "danger", PropTypes.bool), _defineProperty(_defineProperty2, "focusTrap", deprecate(PropTypes.bool, "\nThe prop `focusTrap` for Modal has been deprecated, as the feature of `focusTrap` runs by default.")), _defineProperty(_defineProperty2, "hasForm", PropTypes.bool), _defineProperty(_defineProperty2, "hasScrollingContent", PropTypes.bool), _defineProperty(_defineProperty2, "iconDescription", PropTypes.string), _defineProperty(_defineProperty2, "id", PropTypes.string), _defineProperty(_defineProperty2, "modalAriaLabel", PropTypes.string), _defineProperty(_defineProperty2, "modalHeading", PropTypes.node), _defineProperty(_defineProperty2, "modalLabel", PropTypes.node), _defineProperty(_defineProperty2, "onKeyDown", PropTypes.func), _defineProperty(_defineProperty2, "onRequestClose", PropTypes.func), _defineProperty(_defineProperty2, "onRequestSubmit", PropTypes.func), _defineProperty(_defineProperty2, "onSecondarySubmit", PropTypes.func), _defineProperty(_defineProperty2, "open", PropTypes.bool), _defineProperty(_defineProperty2, "passiveModal", PropTypes.bool), _defineProperty(_defineProperty2, "preventCloseOnClickOutside", PropTypes.bool), _defineProperty(_defineProperty2, "primaryButtonDisabled", PropTypes.bool), _defineProperty(_defineProperty2, "primaryButtonText", PropTypes.node), _defineProperty(_defineProperty2, "secondaryButtonText", PropTypes.node), _defineProperty(_defineProperty2, "secondaryButtons", function secondaryButtons(props, propName, componentName) {
  if (props.secondaryButtons) {
    if (!Array.isArray(props.secondaryButtons) || props.secondaryButtons.length !== 2) {
      return new Error("".concat(propName, " needs to be an array of two button config objects"));
    }

    var shape = {
      buttonText: PropTypes.node,
      onClick: PropTypes.func
    };
    props[propName].forEach(function (secondaryButton) {
      PropTypes.checkPropTypes(shape, secondaryButton, propName, componentName);
    });
  }

  return null;
}), _defineProperty(_defineProperty2, "selectorPrimaryFocus", PropTypes.string), _defineProperty(_defineProperty2, "selectorsFloatingMenus", PropTypes.arrayOf(PropTypes.string)), _defineProperty(_defineProperty2, "shouldSubmitOnEnter", PropTypes.bool), _defineProperty(_defineProperty2, "size", PropTypes.oneOf(['xs', 'sm', 'md', 'lg'])), _defineProperty2));

_defineProperty(Modal, "defaultProps", {
  onRequestClose: function onRequestClose() {},
  onRequestSubmit: function onRequestSubmit() {},
  primaryButtonDisabled: false,
  onKeyDown: function onKeyDown() {},
  passiveModal: false,
  iconDescription: 'Close',
  modalHeading: '',
  modalLabel: '',
  preventCloseOnClickOutside: false,
  selectorPrimaryFocus: '[data-modal-primary-focus]',
  hasScrollingContent: false
});

export { Modal as default };