function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, select, text } from '@storybook/addon-knobs';
import { OverflowMenu } from './OverflowMenu';
import OverflowMenuItem from '../OverflowMenuItem';
import mdx from './OverflowMenu.mdx';
import { Filter16 } from '@carbon/icons-react';
var directions = {
  'Bottom of the trigger button (bottom)': 'bottom',
  'Top of the trigger button (top)': 'top'
};
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var props = {
  menu: function menu() {
    return {
      direction: select('Menu direction (direction)', directions, 'bottom'),
      ariaLabel: text('ARIA label (ariaLabel)', 'Menu'),
      iconDescription: text('Icon description (iconDescription)', ''),
      flipped: boolean('Flipped (flipped)', false),
      light: boolean('Light (light)', false),
      selectorPrimaryFocus: text('Primary focus element selector (selectorPrimaryFocus)', ''),
      size: select('Size (size)', sizes, undefined) || undefined,
      onClick: action('onClick'),
      onFocus: action('onFocus'),
      onKeyDown: action('onKeyDown'),
      onClose: action('onClose'),
      onOpen: action('onOpen')
    };
  },
  menuItem: function menuItem() {
    return {
      className: 'some-class',
      disabled: boolean('Disabled (disabled)', false),
      requireTitle: boolean('Use hover over text for menu item (requireTitle)', false),
      onClick: action('onClick'),
      hasDivider: boolean('Has divider (hasDivider)', false),
      isDelete: boolean('Is delete (isDelete)', false)
    };
  }
};
OverflowMenu.displayName = 'OverflowMenu';
export default {
  title: 'Components/OverflowMenu',
  decorators: [withKnobs],
  component: OverflowMenu,
  subcomponents: {
    OverflowMenuItem: OverflowMenuItem
  },
  parameters: {
    docs: {
      page: mdx
    }
  }
};
export var _Default = function _Default() {
  return /*#__PURE__*/React.createElement(OverflowMenu, null, /*#__PURE__*/React.createElement(OverflowMenuItem, {
    itemText: "Stop app"
  }), /*#__PURE__*/React.createElement(OverflowMenuItem, {
    itemText: "Restart app"
  }), /*#__PURE__*/React.createElement(OverflowMenuItem, {
    itemText: "Rename app"
  }), /*#__PURE__*/React.createElement(OverflowMenuItem, {
    itemText: "Edit routes and access",
    requireTitle: true
  }), /*#__PURE__*/React.createElement(OverflowMenuItem, {
    hasDivider: true,
    isDelete: true,
    itemText: "Delete app"
  }));
};
_Default.story = {
  name: 'Overflow Menu'
};
export var RenderCustomIcon = function RenderCustomIcon() {
  return /*#__PURE__*/React.createElement(OverflowMenu, {
    renderIcon: Filter16
  }, /*#__PURE__*/React.createElement(OverflowMenuItem, {
    itemText: "Filter A"
  }), /*#__PURE__*/React.createElement(OverflowMenuItem, {
    itemText: "Filter B"
  }));
};
export var Playground = function Playground() {
  return /*#__PURE__*/React.createElement(OverflowMenu, props.menu(), /*#__PURE__*/React.createElement(OverflowMenuItem, _extends({}, props.menuItem(), {
    itemText: "Option 1"
  })), /*#__PURE__*/React.createElement(OverflowMenuItem, _extends({}, props.menuItem(), {
    itemText: "Option 2 is an example of a really long string and how we recommend handling this",
    requireTitle: true,
    title: "Custom tooltip title"
  })), /*#__PURE__*/React.createElement(OverflowMenuItem, _extends({}, props.menuItem(), {
    itemText: "Option 3"
  })), /*#__PURE__*/React.createElement(OverflowMenuItem, _extends({}, props.menuItem(), {
    itemText: "Option 4"
  })), /*#__PURE__*/React.createElement(OverflowMenuItem, _extends({}, props.menuItem(), {
    requireTitle: true,
    itemText: "Danger option",
    hasDivider: true,
    isDelete: true
  })));
};