function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2021
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import ProgressBar from './ProgressBar';
import { render } from '@testing-library/react';
import { settings } from 'carbon-components';
var prefix = settings.prefix;
describe('ProgressBar', function () {
  var props = {
    label: 'ProgressBar label'
  };
  var wrapper;
  beforeEach(function () {
    wrapper = render( /*#__PURE__*/React.createElement(ProgressBar, props));
  });
  describe('renders as expected', function () {
    it('progress bar and label ids match', function () {
      var bar = wrapper.getByRole('progressbar');
      var label = wrapper.container.querySelector('span');
      expect(bar.getAttribute('aria-labelledby')).toBe(label.id);
    });
    it('renders helper text when passed', function () {
      var text = 'ProgressBar helper text';
      wrapper.rerender( /*#__PURE__*/React.createElement(ProgressBar, _extends({}, props, {
        helperText: text
      })));
      var helperText = wrapper.container.querySelector(".".concat(prefix, "--progress-bar__helper-text"));
      expect(helperText.textContent).toBe(text);
      expect(wrapper.getByRole('progressbar').getAttribute('aria-describedby')).toBe(helperText.id);
    });
    it('still renders accessible when hideLabel is passed', function () {
      wrapper.rerender( /*#__PURE__*/React.createElement(ProgressBar, _extends({}, props, {
        hideLabel: true
      })));
      var label = wrapper.container.querySelector('span');
      expect(label.textContent).toBe(props.label);
      expect(label.classList.contains("".concat(prefix, "--visually-hidden"))).toBe(true);
    });
    it('renders as indeterminate when no value is passed', function () {
      var bar = wrapper.getByRole('progressbar');
      expect(bar.getAttribute('aria-valuenow')).toBe(null);
      expect(bar.getAttribute('aria-valuemax')).toBe(null);
      expect(bar.getAttribute('aria-valuemin')).toBe(null);
      expect(wrapper.container.querySelector(".".concat(prefix, "--progress-bar")).classList.contains("".concat(prefix, "--progress-bar--indeterminate"))).toBe(true);
    });
    it('sets aria-valuenow correctly', function () {
      var value = 42;
      wrapper.rerender( /*#__PURE__*/React.createElement(ProgressBar, _extends({}, props, {
        value: value
      })));
      expect(wrapper.getByRole('progressbar').getAttribute('aria-valuenow')).toBe(value.toString());
    });
    it('sets aria-valuemax correctly', function () {
      var max = 84;
      wrapper.rerender( /*#__PURE__*/React.createElement(ProgressBar, _extends({}, props, {
        value: 0,
        max: max
      })));
      expect(wrapper.getByRole('progressbar').getAttribute('aria-valuemax')).toBe(max.toString());
    });
    it('supports additional css class names', function () {
      var className = 'some-class';
      wrapper.rerender( /*#__PURE__*/React.createElement(ProgressBar, _extends({}, props, {
        className: className
      })));
      expect(wrapper.container.querySelector(".".concat(prefix, "--progress-bar")).classList.contains(className)).toBe(true);
    });
  });
  describe('behaves as expected', function () {
    it('limits value to max', function () {
      var value = 200;
      var max = 50;
      wrapper.rerender( /*#__PURE__*/React.createElement(ProgressBar, _extends({}, props, {
        value: value,
        max: max
      })));
      expect(wrapper.getByRole('progressbar').getAttribute('aria-valuenow')).toBe(max.toString());
    });
    it('ensures a positive value', function () {
      var value = -10;
      wrapper.rerender( /*#__PURE__*/React.createElement(ProgressBar, _extends({}, props, {
        value: value
      })));
      expect(wrapper.getByRole('progressbar').getAttribute('aria-valuenow')).toBe('0');
    });
  });
});