function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, select, text } from '@storybook/addon-knobs';
import RadioButtonGroup from '../RadioButtonGroup';
import RadioButton from '../RadioButton';
import mdx from './RadioButton.mdx';
var values = {
  'Option 1': 'radio-1',
  'Option 2': 'radio-2',
  'Option 3': 'radio-3'
};
var orientations = {
  'Horizontal (horizontal)': 'horizontal',
  'Vertical (vertical)': 'vertical'
};
var labelPositions = {
  'Left (left)': 'left',
  'Right (right)': 'right'
};
var props = {
  group: function group() {
    return {
      legendText: text('The label (legend) of the RadioButtonGroup (legendText)', 'Radio button heading'),
      name: text('The form control name (name in <RadioButtonGroup>)', 'radio-button-group'),
      valueSelected: select('Value of the selected button (valueSelected in <RadioButtonGroup>)', values, 'radio-3'),
      orientation: select('Radio button orientation (orientation)', orientations, 'horizontal'),
      labelPosition: select('Label position (labelPosition)', labelPositions, 'right'),
      onChange: action('onChange')
    };
  },
  radio: function radio() {
    return {
      className: 'some-class',
      disabled: boolean('Disabled (disabled in <RadioButton>)', false),
      labelText: text('The label of the RadioButton (labelText)', 'Option 1')
    };
  }
};
export default {
  title: 'Components/RadioButton',
  decorators: [withKnobs],
  parameters: {
    component: RadioButtonGroup,
    docs: {
      page: mdx
    },
    subcomponents: {
      RadioButton: RadioButton
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(RadioButtonGroup, {
    legendText: "Radio button heading",
    name: "radio-button-group",
    defaultSelected: "radio-1"
  }, /*#__PURE__*/React.createElement(RadioButton, {
    labelText: "Option 1",
    value: "radio-1",
    id: "radio-1"
  }), /*#__PURE__*/React.createElement(RadioButton, {
    labelText: "Option 2",
    value: "radio-2",
    id: "radio-2"
  }), /*#__PURE__*/React.createElement(RadioButton, {
    labelText: "Option 3",
    value: "radio-3",
    id: "radio-3"
  }));
};
export var Playground = function Playground() {
  var radioProps = props.radio();
  return /*#__PURE__*/React.createElement(RadioButtonGroup, _extends({
    labelText: "Radio Button group"
  }, props.group()), /*#__PURE__*/React.createElement(RadioButton, _extends({
    value: "radio-1",
    id: "radio-1"
  }, radioProps)), /*#__PURE__*/React.createElement(RadioButton, {
    labelText: "Option 2",
    value: "radio-2",
    id: "radio-2"
  }), /*#__PURE__*/React.createElement(RadioButton, {
    labelText: "Option 3",
    value: "radio-3",
    id: "radio-3"
  }));
};