function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable no-console */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, select, text } from '@storybook/addon-knobs';
import Search from '../Search';
import SearchSkeleton from '../Search/Search.Skeleton';
import SearchFilterButton from '../SearchFilterButton';
import SearchLayoutButton from '../SearchLayoutButton';
import ExpandableSearch from '../ExpandableSearch';
import mdx from './Search.mdx';
import { FeatureFlags } from '../FeatureFlags'; // V11: Updated Size Table
// const sizes = {
//   'Small (sm)': 'sm',
//   'Medium (md)': 'md',
//   'Large (lg) - default': 'lg',
// };

var sizes = {
  'Small (sm)': 'sm',
  'Large (lg)': 'lg',
  'Extra Large (xl) - default': 'xl'
};

var props = function props() {
  return {
    className: 'some-class',
    size: select('Size (size)', sizes, 'xl'),
    light: boolean('Light variant (light)', false),
    disabled: boolean('Disabled (disabled)', false),
    name: text('Form item name (name)', ''),
    defaultValue: text('Default value (defaultValue)', ''),
    labelText: text('Label text (labelText)', 'Search'),
    closeButtonLabelText: text('The label text for the close button (closeButtonLabelText)', 'Clear search input'),
    placeholder: text('Placeholder text (placeholder)', 'Search'),
    onChange: action('onChange'),
    onKeyDown: action('onKeyDown')
  };
};

export default {
  title: 'Components/Search',
  decorators: [withKnobs],
  parameters: {
    component: Search,
    docs: {
      page: mdx
    },
    subcomponents: {
      SearchSkeleton: SearchSkeleton,
      SearchFilterButton: SearchFilterButton,
      SearchLayoutButton: SearchLayoutButton,
      ExpandableSearch: ExpandableSearch
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(Search, _extends({}, props(), {
    id: "search-1"
  }));
};
export var SizeStory = function SizeStory() {
  return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("h3", null, "Feature Flags: DISABLED"), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(Search, {
    placeholder: "sm",
    size: "sm",
    id: "search-1"
  }), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(Search, {
    placeholder: "lg",
    size: "lg",
    id: "search-1"
  }), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(Search, {
    placeholder: "xl",
    size: "xl",
    id: "search-1"
  }), /*#__PURE__*/React.createElement("br", null)), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(FeatureFlags, {
    flags: {
      'enable-v11-release': true
    }
  }, /*#__PURE__*/React.createElement("h3", null, "Feature Flags: ENABLED"), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(Search, {
    placeholder: "sm",
    size: "sm",
    id: "search-4"
  }), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(Search, {
    placeholder: "md",
    size: "md",
    id: "search-5"
  }), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(Search, {
    placeholder: "lg",
    size: "lg",
    id: "search-6"
  })));
};
Default.parameters = {
  info: {
    text: "\n            Search enables users to specify a word or a phrase to find particular relevant pieces of content\n            without the use of navigation. Search can be used as the primary means of discovering content,\n            or as a filter to aid the user in finding content.\n          "
  }
};
export var DeprecatedCustomButtons = function DeprecatedCustomButtons() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      display: 'flex'
    }
  }, /*#__PURE__*/React.createElement(Search, _extends({}, props(), {
    id: "search-1"
  })), /*#__PURE__*/React.createElement(SearchFilterButton, {
    onClick: action('onClick')
  }), /*#__PURE__*/React.createElement(SearchLayoutButton, {
    onClick: action('onClick')
  }));
};
DeprecatedCustomButtons.storyName = '[Deprecated] custom buttons';
DeprecatedCustomButtons.parameters = {
  info: {
    text: "\n        You can control what set of buttons you want.\n      "
  }
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      width: '200px'
    }
  }, /*#__PURE__*/React.createElement(SearchSkeleton, null), "\xA0", /*#__PURE__*/React.createElement(SearchSkeleton, {
    small: true
  }));
};
Skeleton.storyName = 'skeleton';
Skeleton.parameters = {
  info: {
    text: "\n        Placeholder skeleton state to use when content is loading.\n      "
  }
};
export var Expandable = function Expandable() {
  return /*#__PURE__*/React.createElement(ExpandableSearch, _extends({}, props(), {
    id: "search-expandable-1"
  }));
};
Expandable.storyName = 'Expandable';