var _excluded = ["children", "selection", "className", "ariaLabel", "border"],
    _excluded2 = ["children", "className"],
    _excluded3 = ["children", "className"],
    _excluded4 = ["onKeyDown", "children", "className", "head"],
    _excluded5 = ["className", "name", "title", "id"],
    _excluded6 = ["children", "className", "head", "noWrap"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { settings } from 'carbon-components';
import { useId } from '../../../internal/useId';
import deprecate from '../../../prop-types/deprecate';
var prefix = settings.prefix;
var GridSelectedRowStateContext = /*#__PURE__*/React.createContext(null);
var GridSelectedRowDispatchContext = /*#__PURE__*/React.createContext(null);
export function StructuredListWrapper(props) {
  var children = props.children,
      selection = props.selection,
      className = props.className,
      ariaLabel = props.ariaLabel,
      _border = props.border,
      other = _objectWithoutProperties(props, _excluded);

  var classes = classNames("".concat(prefix, "--structured-list"), className, _defineProperty({}, "".concat(prefix, "--structured-list--selection"), selection));

  var _React$useState = React.useState(null),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      selectedRow = _React$useState2[0],
      setSelectedRow = _React$useState2[1];

  return /*#__PURE__*/React.createElement(GridSelectedRowStateContext.Provider, {
    value: selectedRow
  }, /*#__PURE__*/React.createElement(GridSelectedRowDispatchContext.Provider, {
    value: setSelectedRow
  }, /*#__PURE__*/React.createElement("div", _extends({
    role: "grid",
    className: classes
  }, other, {
    "aria-label": ariaLabel
  }), children)));
}
StructuredListWrapper.propTypes = {
  /**
   * Specify a label to be read by screen readers on the container node
   */
  ariaLabel: PropTypes.string,

  /**
   * Specify whether a border should be added to your StructuredListWrapper
   */
  border: deprecate(PropTypes.bool, "\nThe prop `border` will be removed in the next major version of Carbon."),

  /**
   * Provide the contents of your StructuredListWrapper
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify whether your StructuredListWrapper should have selections
   */
  selection: PropTypes.bool
};
StructuredListWrapper.defaultProps = {
  selection: false,
  ariaLabel: 'Structured list section'
};
export function StructuredListHead(props) {
  var children = props.children,
      className = props.className,
      other = _objectWithoutProperties(props, _excluded2);

  var classes = classNames("".concat(prefix, "--structured-list-thead"), className);
  return /*#__PURE__*/React.createElement("div", _extends({
    role: "rowgroup",
    className: classes
  }, other), children);
}
StructuredListHead.propTypes = {
  /**
   * Provide the contents of your StructuredListHead
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the node
   */
  className: PropTypes.string
};
export function StructuredListBody(props) {
  var children = props.children,
      className = props.className,
      other = _objectWithoutProperties(props, _excluded3);

  var classes = classNames("".concat(prefix, "--structured-list-tbody"), className);
  return /*#__PURE__*/React.createElement("div", _extends({
    className: classes,
    role: "rowgroup"
  }, other), children);
}
StructuredListBody.propTypes = {
  /**
   * Provide the contents of your StructuredListBody
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,
  head: PropTypes.bool,

  /**
   * Provide a handler that is invoked on the key down event for the control
   */
  onKeyDown: PropTypes.func
};
StructuredListBody.defaultProps = {
  onKeyDown: function onKeyDown() {}
};
var GridRowContext = /*#__PURE__*/React.createContext(null);
export function StructuredListRow(props) {
  var _classNames2;

  var onKeyDown = props.onKeyDown,
      children = props.children,
      className = props.className,
      head = props.head,
      other = _objectWithoutProperties(props, _excluded4);

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      hasFocusWithin = _useState2[0],
      setHasFocusWithin = _useState2[1];

  var id = useId('grid-input');
  var setSelectedRow = React.useContext(GridSelectedRowDispatchContext);
  var value = {
    id: id
  };
  var classes = classNames("".concat(prefix, "--structured-list-row"), className, (_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefix, "--structured-list-row--header-row"), head), _defineProperty(_classNames2, "".concat(prefix, "--structured-list-row--focused-within"), hasFocusWithin), _classNames2));
  return head ? /*#__PURE__*/React.createElement("div", _extends({
    role: "row"
  }, other, {
    className: classes
  }), children) :
  /*#__PURE__*/
  // eslint-disable-next-line jsx-a11y/interactive-supports-focus
  React.createElement("div", _extends({}, other, {
    role: "row",
    className: classes,
    onClick: function onClick() {
      return setSelectedRow(id);
    },
    onFocus: function onFocus() {
      setHasFocusWithin(true);
    },
    onBlur: function onBlur() {
      setHasFocusWithin(false);
    },
    onKeyDown: onKeyDown
  }), /*#__PURE__*/React.createElement(GridRowContext.Provider, {
    value: value
  }, children));
}
StructuredListRow.propTypes = {
  /**
   * Provide the contents of your StructuredListRow
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify whether your StructuredListRow should be used as a header row
   */
  head: PropTypes.bool,

  /**
   * Specify whether a `<label>` should be used
   */
  label: deprecate(PropTypes.bool, "\nThe `label` prop is no longer needed and will be removed in the next major version of Carbon."),

  /**
   * Provide a handler that is invoked on the key down event for the control,
   */
  onKeyDown: PropTypes.func
};
StructuredListRow.defaultProps = {
  head: false,
  onKeyDown: function onKeyDown() {}
};
export function StructuredListInput(props) {
  var defaultId = useId('structureListInput');

  var className = props.className,
      _props$name = props.name,
      name = _props$name === void 0 ? "structured-list-input-".concat(defaultId) : _props$name,
      title = props.title,
      id = props.id,
      other = _objectWithoutProperties(props, _excluded5);

  var classes = classNames("".concat(prefix, "--structured-list-input"), "".concat(prefix, "--visually-hidden"), className);
  var row = React.useContext(GridRowContext);
  var selectedRow = React.useContext(GridSelectedRowStateContext);
  var setSelectedRow = React.useContext(GridSelectedRowDispatchContext);
  return /*#__PURE__*/React.createElement("input", _extends({}, other, {
    type: "radio",
    tabIndex: 0,
    checked: row && row.id === selectedRow,
    value: row ? row.id : '',
    onChange: function onChange(event) {
      setSelectedRow(event.target.value);
    },
    id: !id && defaultId,
    className: classes,
    name: name,
    title: title
  }));
}
StructuredListInput.propTypes = {
  /**
   * Specify an optional className to be applied to the input
   */
  className: PropTypes.string,

  /**
   * Specify whether the underlying input should be checked by default
   */
  defaultChecked: deprecate(PropTypes.bool, "\nThe prop `defaultChecked` is no longer needed and will be removed in the next major version of Carbon."),

  /**
   * Specify a custom `id` for the input
   */
  id: PropTypes.string,

  /**
   * Provide a `name` for the input
   */
  name: PropTypes.string,

  /**
   * Provide an optional hook that is called each time the input is updated
   */
  onChange: deprecate(PropTypes.func, "\nThe prop `onChange` will be removed in the next major version of Carbon."),

  /**
   * Provide a `title` for the input
   */
  title: PropTypes.string,

  /**
   * Specify the value of the input
   */
  value: deprecate(PropTypes.oneOfType([PropTypes.string, PropTypes.number]).isRequired, "\nThe prop `value` will be removed in the next major version of Carbon.")
};
StructuredListInput.defaultProps = {
  title: 'title'
};
export function StructuredListCell(props) {
  var _classNames3;

  var children = props.children,
      className = props.className,
      head = props.head,
      noWrap = props.noWrap,
      other = _objectWithoutProperties(props, _excluded6);

  var classes = classNames(className, (_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix, "--structured-list-th"), head), _defineProperty(_classNames3, "".concat(prefix, "--structured-list-td"), !head), _defineProperty(_classNames3, "".concat(prefix, "--structured-list-content--nowrap"), noWrap), _classNames3));

  if (head) {
    return /*#__PURE__*/React.createElement("span", _extends({
      className: classes,
      role: "columnheader"
    }, other), children);
  }

  return /*#__PURE__*/React.createElement("div", _extends({
    className: classes,
    role: "cell"
  }, other), children);
}
StructuredListCell.propTypes = {
  /**
   * Provide the contents of your StructuredListCell
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify whether your StructuredListCell should be used as a header cell
   */
  head: PropTypes.bool,

  /**
   * Specify whether your StructuredListCell should have text wrapping
   */
  noWrap: PropTypes.bool
};
StructuredListCell.defaultProps = {
  head: false,
  noWrap: false
};
export default {
  StructuredListWrapper: StructuredListWrapper,
  StructuredListHead: StructuredListHead,
  StructuredListBody: StructuredListBody,
  StructuredListRow: StructuredListRow,
  StructuredListInput: StructuredListInput,
  StructuredListCell: StructuredListCell
};