var _excluded = ["selected", "children", "className"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, number, select, text } from '@storybook/addon-knobs';
import { settings } from 'carbon-components';
import classNames from 'classnames';
import './Tabs-story.scss';
import CodeSnippet from '../CodeSnippet';
import Button from '../Button';
import Tabs from '../Tabs';
import Tab from '../Tab';
import TabsSkeleton from '../Tabs/Tabs.Skeleton';
import mdx from './Tabs.mdx';
var selectionModes = {
  'Change selection automatically upon focus (automatic)': 'automatic',
  'Change selection on explicit gesture (manual)': 'manual'
};
var types = {
  Default: 'default',
  Container: 'container'
};
var prefix = settings.prefix;
var props = {
  tabs: function tabs() {
    return {
      type: select('Type of Tabs (type)', types, 'default'),
      className: 'some-class',
      light: boolean('Light variant (light)', false),
      selected: number('The index of the selected tab (selected in <Tabs>)', 1),
      onSelectionChange: action('onSelectionChange'),
      tabContentClassName: text('The className for the child `<TabContent>` components', 'tab-content'),
      scrollIntoView: boolean('Scroll to selected tab on component rerender (scrollIntoView)', true),
      selectionMode: select('Selection mode (selectionMode)', selectionModes, 'automatic')
    };
  },
  tab: function tab() {
    return {
      disabled: boolean('Disabled (disabled in <Tab>)', false),
      onClick: action('onClick'),
      onKeyDown: action('onKeyDown')
    };
  }
};

var CustomLabel = function CustomLabel(_ref) {
  var text = _ref.text;
  return text;
};

var CodeSnippetExample = function CodeSnippetExample() {
  return /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "multi"
  }, "@mixin grid-container {\n  width: 100%;\n  padding-right: padding(mobile);\n  padding-left: padding(mobile);\n  @include breakpoint(bp--xs--major) {\n    padding-right: padding(xs);\n    padding-left: padding(xs);\n  }\n}\n$z-indexes: (\n  modal : 9000,\n  overlay : 8000,\n  dropdown : 7000,\n  header : 6000,\n  footer : 5000,\n  hidden : - 1,\n  overflowHidden: - 1,\n  floating: 10000\n);");
};

var TabContentRenderedOnlyWhenSelected = function TabContentRenderedOnlyWhenSelected(_ref2) {
  var selected = _ref2.selected,
      children = _ref2.children,
      className = _ref2.className,
      other = _objectWithoutProperties(_ref2, _excluded);

  return !selected ? /*#__PURE__*/React.createElement("div", _extends({}, other, {
    className: "".concat(prefix, "--visually-hidden")
  })) : /*#__PURE__*/React.createElement("div", _extends({}, other, {
    className: classNames(className, "".concat(prefix, "--tab-content")),
    role: "tabpanel",
    selected: selected
  }), children);
};

export default {
  title: 'Components/Tabs',
  decorators: [withKnobs],
  parameters: {
    component: Tabs,
    docs: {
      page: mdx
    },
    subcomponents: {
      Tab: Tab,
      TabsSkeleton: TabsSkeleton
    }
  }
};
export var _Default = function _Default() {
  return /*#__PURE__*/React.createElement(Tabs, null, /*#__PURE__*/React.createElement(Tab, {
    id: "tab-1",
    label: "Tab label 1"
  }, /*#__PURE__*/React.createElement("p", null, "Content for first tab goes here.")), /*#__PURE__*/React.createElement(Tab, {
    id: "tab-2",
    label: "Tab label 2"
  }, /*#__PURE__*/React.createElement("p", null, "Content for second tab goes here."), /*#__PURE__*/React.createElement(Button, null, "With a button")), /*#__PURE__*/React.createElement(Tab, {
    id: "tab-3",
    label: "Tab label 3",
    disabled: true
  }, /*#__PURE__*/React.createElement("p", null, "Content for third tab goes here.")), /*#__PURE__*/React.createElement(Tab, {
    id: "tab-4",
    label: "Tab label 4 shows truncation",
    title: "Tab label 4 shows truncation"
  }, /*#__PURE__*/React.createElement("p", null, "Content for fourth tab goes here.")), /*#__PURE__*/React.createElement(Tab, {
    label: /*#__PURE__*/React.createElement("div", null, "Custom Label")
  }, /*#__PURE__*/React.createElement("p", null, "Content for fifth tab goes here.")));
};
_Default.story = {
  name: 'Tabs'
};
export var Playground = function Playground() {
  return /*#__PURE__*/React.createElement("div", {
    className: props.tabs().light ? 'tabs-story-wrapper--light' : null
  }, /*#__PURE__*/React.createElement(Tabs, props.tabs(), /*#__PURE__*/React.createElement(Tab, _extends({}, props.tab(), {
    id: "tab-1",
    label: "Tab label 1"
  }), /*#__PURE__*/React.createElement("div", {
    className: "some-content"
  }, /*#__PURE__*/React.createElement("p", null, "Content for first tab goes here."))), /*#__PURE__*/React.createElement(Tab, _extends({}, props.tab(), {
    id: "tab-2",
    label: "Tab label 2"
  }), /*#__PURE__*/React.createElement("div", {
    className: "some-content"
  }, /*#__PURE__*/React.createElement("p", null, "Content for second tab goes here."))), /*#__PURE__*/React.createElement(Tab, _extends({}, props.tab(), {
    id: "tab-3",
    label: "Tab label 3",
    disabled: true
  }), /*#__PURE__*/React.createElement("div", {
    className: "some-content"
  }, /*#__PURE__*/React.createElement("p", null, "Content for third tab goes here."))), /*#__PURE__*/React.createElement(Tab, _extends({}, props.tab(), {
    id: "tab-4",
    label: "Tab label 4 shows truncation",
    title: "Tab label 4 shows truncation",
    renderContent: TabContentRenderedOnlyWhenSelected
  }), /*#__PURE__*/React.createElement("div", {
    className: "some-content"
  }, /*#__PURE__*/React.createElement("p", null, "Content for fourth tab goes here."), /*#__PURE__*/React.createElement("p", null, "This example uses the\xA0", /*#__PURE__*/React.createElement(CodeSnippet, {
    type: "inline"
  }, "renderContent"), " prop to re-render content when the tab is selected."), /*#__PURE__*/React.createElement(CodeSnippetExample, null))), /*#__PURE__*/React.createElement(Tab, _extends({}, props.tab(), {
    label: /*#__PURE__*/React.createElement(CustomLabel, {
      text: "Custom Label"
    })
  }), /*#__PURE__*/React.createElement("div", {
    className: "some-content"
  }, /*#__PURE__*/React.createElement("p", null, "Content for fifth tab goes here.")))));
};
export var Container = function Container() {
  return /*#__PURE__*/React.createElement(Tabs, {
    type: "container"
  }, /*#__PURE__*/React.createElement(Tab, {
    id: "tab-1",
    label: "Tab label 1"
  }, /*#__PURE__*/React.createElement("p", null, "Content for first tab goes here.")), /*#__PURE__*/React.createElement(Tab, {
    id: "tab-2",
    label: "Tab label 2"
  }, /*#__PURE__*/React.createElement("p", null, "Content for second tab goes here.")), /*#__PURE__*/React.createElement(Tab, {
    id: "tab-3",
    label: "Tab label 3 shows truncation",
    title: "Tab label 3 shows truncation"
  }, /*#__PURE__*/React.createElement("p", null, "Content for third tab goes here.")), /*#__PURE__*/React.createElement(Tab, {
    label: /*#__PURE__*/React.createElement("div", null, "Custom Label")
  }, /*#__PURE__*/React.createElement("p", null, "Content for fourth tab goes here.")));
};
export var Skeleton = function Skeleton() {
  var isLoading = boolean('isLoading', true);
  return /*#__PURE__*/React.createElement("div", {
    style: {
      maxWidth: '100%'
    }
  }, isLoading ? /*#__PURE__*/React.createElement(TabsSkeleton, {
    type: select('Type of Tabs (type)', types, 'default')
  }) : /*#__PURE__*/React.createElement(Tabs, {
    type: select('Type of Tabs (type)', types, 'default')
  }, /*#__PURE__*/React.createElement(Tab, {
    id: "tab-1",
    label: "Tab label 1"
  }, /*#__PURE__*/React.createElement("p", null, "Content for first tab goes here.")), /*#__PURE__*/React.createElement(Tab, {
    id: "tab-2",
    label: "Tab label 2"
  }, /*#__PURE__*/React.createElement("p", null, "Content for second tab goes here.")), /*#__PURE__*/React.createElement(Tab, {
    id: "tab-3",
    label: "Tab label 3",
    disabled: true
  }, /*#__PURE__*/React.createElement("p", null, "Content for third tab goes here.")), /*#__PURE__*/React.createElement(Tab, {
    id: "tab-4",
    label: "Tab label 4 shows truncation",
    title: "Tab label 4 shows truncation"
  }, /*#__PURE__*/React.createElement("p", null, "Content for fourth tab goes here.")), /*#__PURE__*/React.createElement(Tab, {
    label: /*#__PURE__*/React.createElement("div", null, "Custom Label")
  }, /*#__PURE__*/React.createElement("p", null, "Content for fifth tab goes here."))));
};