var _excluded = ["align", "className", "children", "label", "description", "enterDelayMs", "leaveDelayMs"];

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { settings } from 'carbon-components';
import cx from 'classnames';
import PropTypes from 'prop-types';
import React, { useRef } from 'react';
import { Popover, PopoverContent } from '../../Popover';
import { canUseDOM } from '../../../internal/environment';
import { useDelayedState } from '../../../internal/useDelayedState';
import { useEvent } from '../../../internal/useEvent';
import { useId } from '../../../internal/useId';
import { useNoInteractiveChildren } from '../../../internal/useNoInteractiveChildren';
var prefix = settings.prefix;

function Tooltip(_ref) {
  var _ref$align = _ref.align,
      align = _ref$align === void 0 ? 'top' : _ref$align,
      customClassName = _ref.className,
      children = _ref.children,
      label = _ref.label,
      description = _ref.description,
      _ref$enterDelayMs = _ref.enterDelayMs,
      enterDelayMs = _ref$enterDelayMs === void 0 ? 100 : _ref$enterDelayMs,
      _ref$leaveDelayMs = _ref.leaveDelayMs,
      leaveDelayMs = _ref$leaveDelayMs === void 0 ? 300 : _ref$leaveDelayMs,
      rest = _objectWithoutProperties(_ref, _excluded);

  var containerRef = useRef(null);
  var tooltipRef = useRef(null);

  var _useDelayedState = useDelayedState(false),
      _useDelayedState2 = _slicedToArray(_useDelayedState, 2),
      open = _useDelayedState2[0],
      setOpen = _useDelayedState2[1];

  var id = useId('tooltip');
  var child = React.Children.only(children);
  var triggerProps = {
    onFocus: function onFocus() {
      return setOpen(true);
    },
    onBlur: function onBlur() {
      return setOpen(false);
    }
  };

  if (label) {
    triggerProps['aria-labelledby'] = id;
  } else {
    triggerProps['aria-describedby'] = id;
  }

  function onMouseEnter() {
    setOpen(true, enterDelayMs);
  }

  function onMouseLeave() {
    setOpen(false, leaveDelayMs);
  }

  useNoInteractiveChildren(tooltipRef, 'The Tooltip component must have no interactive content rendered by the' + '`label` or `description` prop');

  if (canUseDOM) {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    useEvent(window, 'keydown', function (event) {
      event.stopPropagation();
      setOpen(false);
    });
  }

  return /*#__PURE__*/React.createElement("div", _extends({}, rest, {
    className: cx("".concat(prefix, "--tooltip"), customClassName),
    onMouseEnter: onMouseEnter,
    onMouseLeave: onMouseLeave,
    ref: containerRef
  }), /*#__PURE__*/React.cloneElement(child, triggerProps), /*#__PURE__*/React.createElement(Popover, {
    align: align,
    open: open,
    highContrast: true
  }, /*#__PURE__*/React.createElement(PopoverContent, {
    "aria-hidden": "true",
    className: "".concat(prefix, "--tooltip-content"),
    id: id,
    ref: tooltipRef,
    role: "tooltip"
  }, label || description)));
}

Tooltip.propTypes = {
  /**
   * Specify how the trigger should align with the tooltip
   */
  align: PropTypes.oneOf(['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'left-bottom', 'left-top', 'right', 'right-bottom', 'right-top']),

  /**
   * Pass in the child to which the tooltip will be applied
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Provide the description to be rendered inside of the Tooltip. The
   * description will use `aria-describedby` and will describe the child node
   * in addition to the text rendered inside of the child. This means that if you
   * have text in the child node, that it will be announced alongside the
   * description to the screen reader.
   *
   * Note: if label and description are both provided, label will be used and
   * description will not be used
   */
  description: PropTypes.node,

  /**
   * Specify the duration in milliseconds to delay before displaying the tooltip
   */
  enterDelayMs: PropTypes.number,

  /**
   * Provide the label to be rendered inside of the Tooltip. The label will use
   * `aria-labelledby` and will fully describe the child node that is provided.
   * This means that if you have text in the child node, that it will not be
   * announced to the screen reader.
   *
   * Note: if label and description are both provided, description will not be
   * used
   */
  label: PropTypes.node,

  /**
   * Specify the duration in milliseconds to delay before hiding the tooltip
   */
  leaveDelayMs: PropTypes.number
};
export { Tooltip };