function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import { Search20, Notification20, AppSwitcher20 } from '@carbon/icons-react';
import { action } from '@storybook/addon-actions';
import React, { useState } from 'react';
import { withReadme } from 'storybook-readme';
import readme from './README.md';
import HeaderContainer from './HeaderContainer';
import { Content, Header, HeaderMenuButton, HeaderName, HeaderNavigation, HeaderMenu, HeaderMenuItem, HeaderGlobalBar, HeaderGlobalAction, HeaderPanel, HeaderSideNavItems, SkipToContent, SideNav // Temporarily comment these out until they are needed again
// SideNavHeader,
// SideNavDetails,
// SideNavSwitcher,
, SideNavDivider, SideNavItems, SideNavLink, SideNavMenu, SideNavMenuItem, Switcher, SwitcherItem, SwitcherDivider } from '../UIShell';
import Modal from '../Modal';
import Button from '../Button';
import mdx from './UIShell.mdx';
SideNav.displayName = 'SideNav';
SideNavMenu.displayName = 'SideNavMenu';
SideNavMenuItem.displayName = 'SideNavMenuItem';

var Fade16 = function Fade16() {
  return /*#__PURE__*/React.createElement("svg", {
    width: "16",
    height: "16",
    xmlns: "http://www.w3.org/2000/svg",
    viewBox: "0 0 32 32",
    "aria-hidden": "true"
  }, /*#__PURE__*/React.createElement("path", {
    d: "M8.24 25.14L7 26.67a14 14 0 0 0 4.18 2.44l.68-1.88a12 12 0 0 1-3.62-2.09zm-4.05-7.07l-2 .35A13.89 13.89 0 0 0 3.86 23l1.73-1a11.9 11.9 0 0 1-1.4-3.93zm7.63-13.31l-.68-1.88A14 14 0 0 0 7 5.33l1.24 1.53a12 12 0 0 1 3.58-2.1zM5.59 10L3.86 9a13.89 13.89 0 0 0-1.64 4.54l2 .35A11.9 11.9 0 0 1 5.59 10zM16 2v2a12 12 0 0 1 0 24v2a14 14 0 0 0 0-28z"
  }));
};

var StoryContent = function StoryContent(_ref) {
  var _ref$useResponsiveOff = _ref.useResponsiveOffset,
      useResponsiveOffset = _ref$useResponsiveOff === void 0 ? true : _ref$useResponsiveOff;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      open = _useState2[0],
      setOpen = _useState2[1];

  var classNameFirstColumn = cx({
    'bx--col-lg-13': true,
    'bx--offset-lg-3': useResponsiveOffset
  });
  var content = /*#__PURE__*/React.createElement("div", {
    className: "bx--grid"
  }, /*#__PURE__*/React.createElement("div", {
    className: "bx--row"
  }, /*#__PURE__*/React.createElement("div", {
    className: classNameFirstColumn
  }, /*#__PURE__*/React.createElement("h2", {
    style: {
      margin: '0 0 30px'
    }
  }, "Purpose and function"), /*#__PURE__*/React.createElement("p", null, "The shell is perhaps the most crucial piece of any UI built with", /*#__PURE__*/React.createElement("a", {
    href: "www.carbondesignsystem.com"
  }, " Carbon"), ". It contains the shared navigation framework for the entire design system and ties the products in IBM\u2019s portfolio together in a cohesive and elegant way. The shell is the home of the topmost navigation, where users can quickly and dependably gain their bearings and move between pages.", /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("br", null), "The shell was designed with maximum flexibility built in, to serve the needs of a broad range of products and users. Adopting the shell ensures compliance with IBM design standards, simplifies development efforts, and provides great user experiences. All IBM products built with Carbon are required to use the shell\u2019s header.", /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("br", null), "To better understand the purpose and function of the UI shell, consider the \u201Cshell\u201D of MacOS, which contains the Apple menu, top-level navigation, and universal, OS-level controls at the top of the screen, as well as a universal dock along the bottom or side of the screen. The Carbon UI shell is roughly analogous in function to these parts of the Mac UI. For example, the app switcher portion of the shell can be compared to the dock in MacOS."), /*#__PURE__*/React.createElement("h2", {
    style: {
      margin: '30px 0'
    }
  }, "Header responsive behavior"), /*#__PURE__*/React.createElement("p", null, "As a header scales down to fit smaller screen sizes, headers with persistent side nav menus should have the side nav collapse into \u201Chamburger\u201D menu. See the example to better understand responsive behavior of the header."), /*#__PURE__*/React.createElement("h2", {
    style: {
      margin: '30px 0'
    }
  }, "Secondary navigation"), /*#__PURE__*/React.createElement("p", null, "The side-nav contains secondary navigation and fits below the header. It can be configured to be either fixed-width or flexible, with only one level of nested items allowed. Both links and category lists can be used in the side-nav and may be mixed together. There are several configurations of the side-nav, but only one configuration should be used per product section. If tabs are needed on a page when using a side-nav, then the tabs are secondary in hierarchy to the side-nav."), /*#__PURE__*/React.createElement(Button, {
    onClick: function onClick() {
      return setOpen(true);
    }
  }, "Launch modal"), /*#__PURE__*/React.createElement(Modal, {
    modalHeading: "Add a custom domain",
    modalLabel: "Account resources",
    primaryButtonText: "Add",
    secondaryButtonText: "Cancel",
    open: open,
    onRequestClose: function onRequestClose() {
      return setOpen(false);
    }
  }, /*#__PURE__*/React.createElement("p", {
    style: {
      marginBottom: '1rem'
    }
  }, "Custom domains direct requests for your apps in this Cloud Foundry organization to a URL that you own. A custom domain can be a shared domain, a shared subdomain, or a shared domain and host.")))));
  var style = {
    height: '100%'
  };

  if (useResponsiveOffset) {
    style.margin = '0';
    style.width = '100%';
  }

  return /*#__PURE__*/React.createElement(Content, {
    id: "main-content",
    style: style
  }, content);
};

export default {
  title: 'Components/UI Shell',
  parameters: {
    docs: {
      page: mdx
    },
    subcomponents: {
      Content: Content,
      Header: Header,
      HeaderMenuButton: HeaderMenuButton,
      HeaderName: HeaderName,
      HeaderNavigation: HeaderNavigation,
      HeaderMenu: HeaderMenu,
      HeaderMenuItem: HeaderMenuItem,
      HeaderGlobalBar: HeaderGlobalBar,
      HeaderGlobalAction: HeaderGlobalAction,
      HeaderPanel: HeaderPanel,
      HeaderSideNavItems: HeaderSideNavItems,
      SkipToContent: SkipToContent,
      SideNav: SideNav,
      SideNavItems: SideNavItems,
      SideNavDivider: SideNavDivider,
      SideNavLink: SideNavLink,
      SideNavMenu: SideNavMenu,
      SideNavMenuItem: SideNavMenuItem,
      Switcher: Switcher,
      SwitcherItem: SwitcherItem,
      SwitcherDivider: SwitcherDivider
    }
  }
};
export var HeaderBase = withReadme(readme, function () {
  return /*#__PURE__*/React.createElement(Header, {
    "aria-label": "IBM Platform Name"
  }, /*#__PURE__*/React.createElement(HeaderName, {
    href: "#",
    prefix: "IBM"
  }, "[Platform]"));
});
export var HeaderBaseWNavigation = withReadme(readme, function () {
  return /*#__PURE__*/React.createElement(HeaderContainer, {
    render: function render(_ref2) {
      var isSideNavExpanded = _ref2.isSideNavExpanded,
          onClickSideNavExpand = _ref2.onClickSideNavExpand;
      return /*#__PURE__*/React.createElement(Header, {
        "aria-label": "IBM Platform Name"
      }, /*#__PURE__*/React.createElement(SkipToContent, null), /*#__PURE__*/React.createElement(HeaderMenuButton, {
        "aria-label": "Open menu",
        onClick: onClickSideNavExpand,
        isActive: isSideNavExpanded
      }), /*#__PURE__*/React.createElement(HeaderName, {
        href: "#",
        prefix: "IBM"
      }, "[Platform]"), /*#__PURE__*/React.createElement(HeaderNavigation, {
        "aria-label": "IBM [Platform]"
      }, /*#__PURE__*/React.createElement(HeaderMenuItem, {
        isCurrentPage: true,
        href: "#"
      }, "Link 1"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/React.createElement(HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))), /*#__PURE__*/React.createElement(SideNav, {
        "aria-label": "Side navigation",
        expanded: isSideNavExpanded,
        isPersistent: false
      }, /*#__PURE__*/React.createElement(SideNavItems, null, /*#__PURE__*/React.createElement(HeaderSideNavItems, null, /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/React.createElement(HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))))));
    }
  });
});
HeaderBaseWNavigation.storyName = 'Header Base w/ Navigation';
export var HeaderBaseWActions = withReadme(readme, function () {
  return /*#__PURE__*/React.createElement(Header, {
    "aria-label": "IBM Platform Name"
  }, /*#__PURE__*/React.createElement(HeaderName, {
    href: "#",
    prefix: "IBM"
  }, "[Platform]"), /*#__PURE__*/React.createElement(HeaderGlobalBar, null, /*#__PURE__*/React.createElement(HeaderGlobalAction, {
    "aria-label": "Search",
    onClick: action('search click')
  }, /*#__PURE__*/React.createElement(Search20, null)), /*#__PURE__*/React.createElement(HeaderGlobalAction, {
    "aria-label": "Notifications",
    onClick: action('notification click')
  }, /*#__PURE__*/React.createElement(Notification20, null)), /*#__PURE__*/React.createElement(HeaderGlobalAction, {
    "aria-label": "App Switcher",
    onClick: action('app-switcher click'),
    tooltipAlignment: "end"
  }, /*#__PURE__*/React.createElement(AppSwitcher20, null))));
});
HeaderBaseWActions.storyName = 'Header Base w/ Actions';
export var HeaderBaseWSkipToContent = withReadme(readme, function () {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Header, {
    "aria-label": "IBM Platform Name"
  }, /*#__PURE__*/React.createElement(SkipToContent, null), /*#__PURE__*/React.createElement(HeaderName, {
    href: "#",
    prefix: "IBM"
  }, "[Platform]"), /*#__PURE__*/React.createElement(HeaderGlobalBar, null, /*#__PURE__*/React.createElement(HeaderGlobalAction, {
    "aria-label": "Search",
    onClick: action('search click')
  }, /*#__PURE__*/React.createElement(Search20, null)), /*#__PURE__*/React.createElement(HeaderGlobalAction, {
    "aria-label": "Notifications",
    onClick: action('notification click')
  }, /*#__PURE__*/React.createElement(Notification20, null)), /*#__PURE__*/React.createElement(HeaderGlobalAction, {
    "aria-label": "App Switcher",
    onClick: action('app-switcher click'),
    tooltipAlignment: "end"
  }, /*#__PURE__*/React.createElement(AppSwitcher20, null)))), /*#__PURE__*/React.createElement(StoryContent, null));
});
HeaderBaseWSkipToContent.storyName = 'Header Base w/ SkipToContent';
export var HeaderBaseWNavigationAndActions = withReadme(readme, function () {
  return /*#__PURE__*/React.createElement(HeaderContainer, {
    render: function render(_ref3) {
      var isSideNavExpanded = _ref3.isSideNavExpanded,
          onClickSideNavExpand = _ref3.onClickSideNavExpand;
      return /*#__PURE__*/React.createElement(Header, {
        "aria-label": "IBM Platform Name"
      }, /*#__PURE__*/React.createElement(SkipToContent, null), /*#__PURE__*/React.createElement(HeaderMenuButton, {
        "aria-label": "Open menu",
        onClick: onClickSideNavExpand,
        isActive: isSideNavExpanded
      }), /*#__PURE__*/React.createElement(HeaderName, {
        href: "#",
        prefix: "IBM"
      }, "[Platform]"), /*#__PURE__*/React.createElement(HeaderNavigation, {
        "aria-label": "IBM [Platform]"
      }, /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/React.createElement(HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))), /*#__PURE__*/React.createElement(HeaderGlobalBar, null, /*#__PURE__*/React.createElement(HeaderGlobalAction, {
        "aria-label": "Search",
        onClick: action('search click')
      }, /*#__PURE__*/React.createElement(Search20, null)), /*#__PURE__*/React.createElement(HeaderGlobalAction, {
        "aria-label": "Notifications",
        onClick: action('notification click')
      }, /*#__PURE__*/React.createElement(Notification20, null)), /*#__PURE__*/React.createElement(HeaderGlobalAction, {
        "aria-label": "App Switcher",
        onClick: action('app-switcher click'),
        tooltipAlignment: "end"
      }, /*#__PURE__*/React.createElement(AppSwitcher20, null))), /*#__PURE__*/React.createElement(SideNav, {
        "aria-label": "Side navigation",
        expanded: isSideNavExpanded,
        isPersistent: false
      }, /*#__PURE__*/React.createElement(SideNavItems, null, /*#__PURE__*/React.createElement(HeaderSideNavItems, null, /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/React.createElement(HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))))));
    }
  });
});
HeaderBaseWNavigationAndActions.storyName = 'Header Base w/ Navigation and Actions';
export var HeaderBaseWNavigationActionsAndSideNav = withReadme(readme, function () {
  return /*#__PURE__*/React.createElement(HeaderContainer, {
    render: function render(_ref4) {
      var isSideNavExpanded = _ref4.isSideNavExpanded,
          onClickSideNavExpand = _ref4.onClickSideNavExpand;
      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Header, {
        "aria-label": "IBM Platform Name"
      }, /*#__PURE__*/React.createElement(SkipToContent, null), /*#__PURE__*/React.createElement(HeaderMenuButton, {
        "aria-label": "Open menu",
        onClick: onClickSideNavExpand,
        isActive: isSideNavExpanded
      }), /*#__PURE__*/React.createElement(HeaderName, {
        href: "#",
        prefix: "IBM"
      }, "[Platform]"), /*#__PURE__*/React.createElement(HeaderNavigation, {
        "aria-label": "IBM [Platform]"
      }, /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/React.createElement(HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#one"
      }, "Sub-link 1"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#two"
      }, "Sub-link 2"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#three"
      }, "Sub-link 3"))), /*#__PURE__*/React.createElement(HeaderGlobalBar, null, /*#__PURE__*/React.createElement(HeaderGlobalAction, {
        "aria-label": "Search",
        onClick: action('search click')
      }, /*#__PURE__*/React.createElement(Search20, null)), /*#__PURE__*/React.createElement(HeaderGlobalAction, {
        "aria-label": "Notifications",
        onClick: action('notification click')
      }, /*#__PURE__*/React.createElement(Notification20, null)), /*#__PURE__*/React.createElement(HeaderGlobalAction, {
        "aria-label": "App Switcher",
        onClick: action('app-switcher click'),
        tooltipAlignment: "end"
      }, /*#__PURE__*/React.createElement(AppSwitcher20, null))), /*#__PURE__*/React.createElement(SideNav, {
        "aria-label": "Side navigation",
        expanded: isSideNavExpanded
      }, /*#__PURE__*/React.createElement(SideNavItems, null, /*#__PURE__*/React.createElement(HeaderSideNavItems, {
        hasDivider: true
      }, /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/React.createElement(HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))), /*#__PURE__*/React.createElement(SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title"
      }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/React.createElement(SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title"
      }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/React.createElement(SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title",
        isActive: true
      }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        "aria-current": "page",
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/React.createElement(SideNavLink, {
        renderIcon: Fade16,
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavLink, {
        renderIcon: Fade16,
        href: "javascript:void(0)"
      }, "Link")))), /*#__PURE__*/React.createElement(StoryContent, null));
    }
  });
});
HeaderBaseWNavigationActionsAndSideNav.storyName = 'Header Base w/ Navigation, Actions and SideNav';
export var HeaderBaseWSideNav = withReadme(readme, function () {
  return /*#__PURE__*/React.createElement(HeaderContainer, {
    render: function render(_ref5) {
      var isSideNavExpanded = _ref5.isSideNavExpanded,
          onClickSideNavExpand = _ref5.onClickSideNavExpand;
      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Header, {
        "aria-label": "IBM Platform Name"
      }, /*#__PURE__*/React.createElement(SkipToContent, null), /*#__PURE__*/React.createElement(HeaderMenuButton, {
        "aria-label": "Open menu",
        onClick: onClickSideNavExpand,
        isActive: isSideNavExpanded
      }), /*#__PURE__*/React.createElement(HeaderName, {
        href: "#",
        prefix: "IBM"
      }, "[Platform]"), /*#__PURE__*/React.createElement(SideNav, {
        "aria-label": "Side navigation",
        expanded: isSideNavExpanded
      }, /*#__PURE__*/React.createElement(SideNavItems, null, /*#__PURE__*/React.createElement(SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title"
      }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/React.createElement(SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title",
        isActive: true
      }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        "aria-current": "page",
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/React.createElement(SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title"
      }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/React.createElement(SideNavLink, {
        renderIcon: Fade16,
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavLink, {
        renderIcon: Fade16,
        href: "javascript:void(0)"
      }, "Link")))), /*#__PURE__*/React.createElement(StoryContent, null));
    }
  });
});
HeaderBaseWSideNav.storyName = 'Header Base w/ SideNav';
export var HeaderBaseWActionsAndRightPanel = withReadme(readme, function () {
  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      expanded = _useState4[0],
      setExpanded = _useState4[1];

  var toggleRightPanel = function toggleRightPanel() {
    setExpanded(!expanded);
  };

  return /*#__PURE__*/React.createElement(Header, {
    "aria-label": "IBM Platform Name"
  }, /*#__PURE__*/React.createElement(HeaderName, {
    href: "#",
    prefix: "IBM"
  }, "[Platform]"), /*#__PURE__*/React.createElement(HeaderGlobalBar, null, /*#__PURE__*/React.createElement(HeaderGlobalAction, {
    tooltipAlignment: "end",
    isActive: expanded,
    "aria-label": "Notifications",
    onClick: toggleRightPanel
  }, /*#__PURE__*/React.createElement(Notification20, null))), /*#__PURE__*/React.createElement(HeaderPanel, {
    "aria-label": "Header Panel",
    expanded: expanded
  }));
});
HeaderBaseWActionsAndRightPanel.storyName = 'Header Base w/ Actions and Right Panel with Animation';
export var HeaderBaseWActionsAndSwitcher = withReadme(readme, function () {
  return /*#__PURE__*/React.createElement(Header, {
    "aria-label": "IBM Platform Name"
  }, /*#__PURE__*/React.createElement(HeaderName, {
    href: "#",
    prefix: "IBM"
  }, "[Platform]"), /*#__PURE__*/React.createElement(HeaderGlobalBar, null, /*#__PURE__*/React.createElement(HeaderGlobalAction, {
    "aria-label": "Search",
    onClick: action('search click')
  }, /*#__PURE__*/React.createElement(Search20, null)), /*#__PURE__*/React.createElement(HeaderGlobalAction, {
    "aria-label": "Notifications",
    onClick: action('notification click')
  }, /*#__PURE__*/React.createElement(Notification20, null)), /*#__PURE__*/React.createElement(HeaderGlobalAction, {
    "aria-label": "App Switcher",
    isActive: true,
    onClick: action('app-switcher click'),
    tooltipAlignment: "end"
  }, /*#__PURE__*/React.createElement(AppSwitcher20, null))), /*#__PURE__*/React.createElement(HeaderPanel, {
    "aria-label": "Header Panel",
    expanded: true
  }, /*#__PURE__*/React.createElement(Switcher, {
    "aria-label": "Switcher Container"
  }, /*#__PURE__*/React.createElement(SwitcherItem, {
    isSelected: true,
    "aria-label": "Link 1",
    href: "#"
  }, "Link 1"), /*#__PURE__*/React.createElement(SwitcherDivider, null), /*#__PURE__*/React.createElement(SwitcherItem, {
    href: "#",
    "aria-label": "Link 2"
  }, "Link 2"), /*#__PURE__*/React.createElement(SwitcherItem, {
    href: "#",
    "aria-label": "Link 3"
  }, "Link 3"), /*#__PURE__*/React.createElement(SwitcherItem, {
    href: "#",
    "aria-label": "Link 4"
  }, "Link 4"), /*#__PURE__*/React.createElement(SwitcherItem, {
    href: "#",
    "aria-label": "Link 5"
  }, "Link 5"), /*#__PURE__*/React.createElement(SwitcherDivider, null), /*#__PURE__*/React.createElement(SwitcherItem, {
    href: "#",
    "aria-label": "Link 6"
  }, "Link 6"))));
});
HeaderBaseWActionsAndSwitcher.storyName = 'Header Base w/ Actions and Switcher';
export var FixedSideNav = withReadme(readme, function () {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(SideNav, {
    isFixedNav: true,
    expanded: true,
    isChildOfHeader: false,
    "aria-label": "Side navigation"
  }, /*#__PURE__*/React.createElement(SideNavItems, null, /*#__PURE__*/React.createElement(SideNavMenu, {
    title: "L0 menu"
  }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item")), /*#__PURE__*/React.createElement(SideNavMenu, {
    title: "L0 menu",
    isActive: true
  }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    "aria-current": "page",
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item")), /*#__PURE__*/React.createElement(SideNavMenu, {
    title: "L0 menu"
  }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item")), /*#__PURE__*/React.createElement(SideNavLink, {
    href: "javascript:void(0)"
  }, "L0 link"), /*#__PURE__*/React.createElement(SideNavLink, {
    href: "javascript:void(0)"
  }, "L0 link"))), /*#__PURE__*/React.createElement(StoryContent, {
    useResponsiveOffset: false
  }));
});
FixedSideNav.storyName = 'Fixed SideNav';
export var FixedSideNavWIcons = withReadme(readme, function () {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(SideNav, {
    isFixedNav: true,
    expanded: true,
    isChildOfHeader: false,
    "aria-label": "Side navigation"
  }, /*#__PURE__*/React.createElement(SideNavItems, null, /*#__PURE__*/React.createElement(SideNavMenu, {
    renderIcon: Fade16,
    title: "Category title"
  }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link")), /*#__PURE__*/React.createElement(SideNavMenu, {
    renderIcon: Fade16,
    title: "Category title",
    isActive: true
  }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    "aria-current": "page",
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link")), /*#__PURE__*/React.createElement(SideNavMenu, {
    renderIcon: Fade16,
    title: "Category title"
  }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link")), /*#__PURE__*/React.createElement(SideNavLink, {
    renderIcon: Fade16,
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/React.createElement(SideNavLink, {
    renderIcon: Fade16,
    href: "javascript:void(0)"
  }, "Link"))), /*#__PURE__*/React.createElement(StoryContent, {
    useResponsiveOffset: false
  }));
});
FixedSideNavWIcons.storyName = 'Fixed SideNav w/ Icons';
export var FixedSideNavWDivider = withReadme(readme, function () {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(SideNav, {
    isFixedNav: true,
    expanded: true,
    isChildOfHeader: false,
    "aria-label": "Side navigation"
  }, /*#__PURE__*/React.createElement(SideNavItems, null, /*#__PURE__*/React.createElement(SideNavMenu, {
    title: "L0 menu"
  }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item")), /*#__PURE__*/React.createElement(SideNavMenu, {
    title: "L0 menu",
    isActive: true
  }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    "aria-current": "page",
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item")), /*#__PURE__*/React.createElement(SideNavMenu, {
    title: "L0 menu"
  }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "L0 menu item")), /*#__PURE__*/React.createElement(SideNavDivider, null), /*#__PURE__*/React.createElement(SideNavLink, {
    href: "javascript:void(0)"
  }, "L0 link"), /*#__PURE__*/React.createElement(SideNavLink, {
    href: "javascript:void(0)"
  }, "L0 link"))), /*#__PURE__*/React.createElement(StoryContent, {
    useResponsiveOffset: false
  }));
});
FixedSideNavWDivider.storyName = 'Fixed SideNav w/ Divider';
export var SideNavRail = withReadme(readme, function () {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(SideNav, {
    "aria-label": "Side navigation",
    isRail: true
  }, /*#__PURE__*/React.createElement(SideNavItems, null, /*#__PURE__*/React.createElement(SideNavMenu, {
    renderIcon: Fade16,
    title: "Category title"
  }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    "aria-current": "page",
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link")), /*#__PURE__*/React.createElement(SideNavMenu, {
    renderIcon: Fade16,
    title: "Category title"
  }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link")), /*#__PURE__*/React.createElement(SideNavMenu, {
    renderIcon: Fade16,
    title: "Category title"
  }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Link")), /*#__PURE__*/React.createElement(SideNavLink, {
    renderIcon: Fade16,
    href: "javascript:void(0)"
  }, "Link"), /*#__PURE__*/React.createElement(SideNavLink, {
    renderIcon: Fade16,
    href: "javascript:void(0)"
  }, "Link"))), /*#__PURE__*/React.createElement(StoryContent, null));
});
SideNavRail.storyName = 'SideNav Rail';
export var SideNavRailWHeader = withReadme(readme, function () {
  return /*#__PURE__*/React.createElement(HeaderContainer, {
    render: function render(_ref6) {
      var isSideNavExpanded = _ref6.isSideNavExpanded,
          onClickSideNavExpand = _ref6.onClickSideNavExpand;
      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Header, {
        "aria-label": "IBM Platform Name"
      }, /*#__PURE__*/React.createElement(SkipToContent, null), /*#__PURE__*/React.createElement(HeaderMenuButton, {
        "aria-label": "Open menu",
        isCollapsible: true,
        onClick: onClickSideNavExpand,
        isActive: isSideNavExpanded
      }), /*#__PURE__*/React.createElement(HeaderName, {
        href: "#",
        prefix: "IBM"
      }, "[Platform]"), /*#__PURE__*/React.createElement(HeaderNavigation, {
        "aria-label": "IBM [Platform]"
      }, /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 1"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 2"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Link 3"), /*#__PURE__*/React.createElement(HeaderMenu, {
        "aria-label": "Link 4",
        menuLinkName: "Link 4"
      }, /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 1"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 2"), /*#__PURE__*/React.createElement(HeaderMenuItem, {
        href: "#"
      }, "Sub-link 3"))), /*#__PURE__*/React.createElement(HeaderGlobalBar, null, /*#__PURE__*/React.createElement(HeaderGlobalAction, {
        "aria-label": "Search",
        onClick: action('search click')
      }, /*#__PURE__*/React.createElement(Search20, null)), /*#__PURE__*/React.createElement(HeaderGlobalAction, {
        "aria-label": "Notifications",
        onClick: action('notification click')
      }, /*#__PURE__*/React.createElement(Notification20, null)), /*#__PURE__*/React.createElement(HeaderGlobalAction, {
        "aria-label": "App Switcher",
        onClick: action('app-switcher click'),
        tooltipAlignment: "end"
      }, /*#__PURE__*/React.createElement(AppSwitcher20, null))), /*#__PURE__*/React.createElement(SideNav, {
        "aria-label": "Side navigation",
        isRail: true,
        expanded: isSideNavExpanded,
        onOverlayClick: onClickSideNavExpand
      }, /*#__PURE__*/React.createElement(SideNavItems, null, /*#__PURE__*/React.createElement(SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title"
      }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        "aria-current": "page",
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/React.createElement(SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title"
      }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        "aria-current": "page",
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/React.createElement(SideNavMenu, {
        renderIcon: Fade16,
        title: "Category title"
      }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        "aria-current": "page",
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
        href: "javascript:void(0)"
      }, "Link")), /*#__PURE__*/React.createElement(SideNavLink, {
        renderIcon: Fade16,
        href: "javascript:void(0)"
      }, "Link"), /*#__PURE__*/React.createElement(SideNavLink, {
        renderIcon: Fade16,
        href: "javascript:void(0)"
      }, "Link")))), /*#__PURE__*/React.createElement(StoryContent, null));
    }
  });
});
SideNavRailWHeader.storyName = 'SideNav Rail w/Header';
export var SideNavWLargeSideNavItems = withReadme(readme, function () {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(SideNav, {
    expanded: true,
    isChildOfHeader: false,
    "aria-label": "Side navigation"
  }, /*#__PURE__*/React.createElement(SideNavItems, null, /*#__PURE__*/React.createElement(SideNavMenu, {
    title: "Large menu",
    large: true
  }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Menu 1"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Menu 2"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Menu 3")), /*#__PURE__*/React.createElement(SideNavLink, {
    href: "javascript:void(0)",
    large: true
  }, "Large link"), /*#__PURE__*/React.createElement(SideNavMenu, {
    renderIcon: Fade16,
    title: "Large menu w/icon",
    large: true
  }, /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Menu 1"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Menu 2"), /*#__PURE__*/React.createElement(SideNavMenuItem, {
    href: "javascript:void(0)"
  }, "Menu 3")), /*#__PURE__*/React.createElement(SideNavLink, {
    renderIcon: Fade16,
    href: "javascript:void(0)",
    large: true
  }, "Large link w/icon"))), /*#__PURE__*/React.createElement(StoryContent, null));
});
SideNavWLargeSideNavItems.storyName = 'SideNav w/ large side nav items';