function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { useEffect, useRef, useState } from 'react';
import { warning } from './warning';
export function useControllableState(controlledState, controlledSetState, defaultValue) {
  var controlled = useRef(controlledState !== undefined);

  var _useState = useState(function () {
    if (controlled.current === true) {
      return controlledState;
    }

    return defaultValue;
  }),
      _useState2 = _slicedToArray(_useState, 2),
      state = _useState2[0],
      internalSetState = _useState2[1]; // If the owner is controlling the component prop value, keep the controlled
  // state value and the internal state value in sync.
  //
  // We guard on `undefined` to prevent downstream breakage of controlled
  // components (like <input>). When the controlled state switches to
  // `undefined`, we are moving from controlled to uncontrolled.


  if (controlled.current === true && controlledState !== state && controlledState !== undefined) {
    internalSetState(controlledState);
  }

  function setState(stateOrUpdater) {
    if (controlled.current === true) {
      controlledSetState(stateOrUpdater);
    } else {
      internalSetState(stateOrUpdater);
    }
  }

  useEffect(function () {
    // Uncontrolled -> Controlled
    // If the component prop is uncontrolled, the prop value should be undefined
    if (controlled.current === false && controlledState !== undefined) {
      process.env.NODE_ENV !== "production" ? warning(false, 'A component is changing an uncontrolled component to be controlled. ' + 'This is likely caused by the value changing to a defined value ' + 'from undefined. Decide between using a controlled or uncontrolled ' + 'value for the lifetime of the component. ' + 'More info: https://reactjs.org/link/controlled-components') : void 0;
    } // Controlled -> Uncontrolled
    // If the component prop is controlled, the prop value should be defined


    if (controlled.current === true && controlledState === undefined) {
      process.env.NODE_ENV !== "production" ? warning(false, 'A component is changing a controlled component to be uncontrolled. ' + 'This is likely caused by the value changing to an undefined value ' + 'from a defined one. Decide between using a controlled or ' + 'uncontrolled value for the lifetime of the component. ' + 'More info: https://reactjs.org/link/controlled-components') : void 0;
    }
  }, [controlledState]);
  return [state, setState];
}