/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var emptyFunction = function emptyFunction() {};

var warning = process.env.NODE_ENV !== "production" ? function warning(condition, format) {
  for (var _len = arguments.length, args = new Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
    args[_key - 2] = arguments[_key];
  }

  if (format === undefined) {
    throw new Error('`warning(condition, format, ...args)` requires a warning ' + 'format argument');
  }

  if (!condition) {
    var index = 0;
    var message = format.replace(/%s/g, function () {
      return args[index++];
    });
    console.warn('Warning: ' + message);
  }
} : emptyFunction;
export { warning };