"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _Text = require("../Text");

var _keyboard = require("../../internal/keyboard");

var _useId = require("../../internal/useId");

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate.js"));

var _excluded = ["children", "className", "iconDescription", "open", "onHeadingClick", "renderExpando", "title", "disabled"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var prefix = _carbonComponents.settings.prefix;

var defaultRenderExpando = function defaultRenderExpando(props) {
  return /*#__PURE__*/_react.default.createElement("button", _extends({
    type: "button"
  }, props));
};

function AccordionItem(_ref) {
  var _cx;

  var children = _ref.children,
      customClassName = _ref.className,
      iconDescription = _ref.iconDescription,
      _ref$open = _ref.open,
      open = _ref$open === void 0 ? false : _ref$open,
      onHeadingClick = _ref.onHeadingClick,
      _ref$renderExpando = _ref.renderExpando,
      Expando = _ref$renderExpando === void 0 ? defaultRenderExpando : _ref$renderExpando,
      _ref$title = _ref.title,
      title = _ref$title === void 0 ? 'title' : _ref$title,
      disabled = _ref.disabled,
      rest = _objectWithoutProperties(_ref, _excluded);

  var _useState = (0, _react.useState)(open),
      _useState2 = _slicedToArray(_useState, 2),
      isOpen = _useState2[0],
      setIsOpen = _useState2[1];

  var _useState3 = (0, _react.useState)(open),
      _useState4 = _slicedToArray(_useState3, 2),
      prevIsOpen = _useState4[0],
      setPrevIsOpen = _useState4[1];

  var _useState5 = (0, _react.useState)(''),
      _useState6 = _slicedToArray(_useState5, 2),
      animation = _useState6[0],
      setAnimation = _useState6[1];

  var id = (0, _useId.useId)('accordion-item');
  var className = (0, _classnames.default)((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--accordion__item"), true), _defineProperty(_cx, "".concat(prefix, "--accordion__item--active"), isOpen), _defineProperty(_cx, "".concat(prefix, "--accordion__item--").concat(animation), animation), _defineProperty(_cx, "".concat(prefix, "--accordion__item--disabled"), disabled), _defineProperty(_cx, customClassName, !!customClassName), _cx));

  if (open !== prevIsOpen) {
    setAnimation(isOpen ? 'collapsing' : 'expanding');
    setIsOpen(open);
    setPrevIsOpen(open);
  } // When the AccordionItem heading is clicked, toggle the open state of the
  // panel


  function onClick(event) {
    var nextValue = !isOpen;
    setAnimation(isOpen ? 'collapsing' : 'expanding');
    setIsOpen(nextValue);

    if (onHeadingClick) {
      // TODO: normalize signature, potentially:
      // onHeadingClick :: (event: Event, state: { isOpen: Boolean }) => any
      onHeadingClick({
        isOpen: nextValue,
        event: event
      });
    }
  } // If the AccordionItem is open, and the user hits the ESC key, then close it


  function onKeyDown(event) {
    if (isOpen && (0, _keyboard.match)(event, _keyboard.keys.Escape)) {
      setIsOpen(false);
    }
  }

  function handleAnimationEnd(event) {
    if (rest.handleAnimationEnd) {
      rest.handleAnimationEnd(event);
    }

    setAnimation('');
  }

  return /*#__PURE__*/_react.default.createElement("li", _extends({
    className: className
  }, rest, {
    onAnimationEnd: handleAnimationEnd
  }), /*#__PURE__*/_react.default.createElement(Expando, {
    disabled: disabled,
    "aria-controls": id,
    "aria-expanded": isOpen,
    className: "".concat(prefix, "--accordion__heading"),
    onClick: onClick,
    onKeyDown: onKeyDown,
    type: "button"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronRight16, {
    className: "".concat(prefix, "--accordion__arrow")
  }), /*#__PURE__*/_react.default.createElement(_Text.Text, {
    as: "div",
    className: "".concat(prefix, "--accordion__title")
  }, title)), /*#__PURE__*/_react.default.createElement("div", {
    id: id,
    className: "".concat(prefix, "--accordion__content")
  }, children));
}

AccordionItem.propTypes = {
  /**
   * Provide the contents of your AccordionItem
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether an individual AccordionItem should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * The description of the expando icon.
   */
  iconDescription: (0, _deprecate.default)(_propTypes.default.string, 'The `iconDescription` prop has been deprecated as it is no longer ' + 'required. Feel free to remove this prop from <AccordionItem>. This ' + 'prop will be removed in the next major release of ' + '`carbon-components-react`'),

  /**
   * The handler of the massaged `click` event.
   */
  onClick: _propTypes.default.func,

  /**
   * The handler of the massaged `click` event on the heading.
   */
  onHeadingClick: _propTypes.default.func,

  /**
   * `true` to open the expando.
   */
  open: _propTypes.default.bool,

  /**
   * The callback function to render the expando button.
   * Can be a React component class.
   */
  renderExpando: _propTypes.default.func,

  /**
   * The accordion title.
   */
  title: _propTypes.default.node
};
var _default = AccordionItem;
exports.default = _default;