"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.playground = exports.skeleton = exports.breadcrumbWithOverflowMenu = exports.breadcrumb = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Breadcrumb = require("../Breadcrumb");

var _OverflowMenu = _interopRequireDefault(require("../OverflowMenu"));

var _OverflowMenuItem = _interopRequireDefault(require("../OverflowMenuItem"));

var _Breadcrumb2 = _interopRequireDefault(require("./Breadcrumb.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var _default = {
  title: 'Components/Breadcrumb',
  component: _Breadcrumb.Breadcrumb,
  subcomponents: {
    BreadcrumbItem: _Breadcrumb.BreadcrumbItem,
    BreadcrumbSkeleton: _Breadcrumb.BreadcrumbSkeleton
  },
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    docs: {
      page: _Breadcrumb2.default
    }
  }
};
exports.default = _default;

var breadcrumb = function breadcrumb() {
  return /*#__PURE__*/_react.default.createElement(_Breadcrumb.Breadcrumb, null, /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, null, /*#__PURE__*/_react.default.createElement("a", {
    href: "/#"
  }, "Breadcrumb 1")), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, {
    href: "#"
  }, "Breadcrumb 2"), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, {
    href: "#"
  }, "Breadcrumb 3"), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, null, "Breadcrumb 4"));
};

exports.breadcrumb = breadcrumb;

var breadcrumbWithOverflowMenu = function breadcrumbWithOverflowMenu() {
  return /*#__PURE__*/_react.default.createElement(_Breadcrumb.Breadcrumb, null, /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, null, /*#__PURE__*/_react.default.createElement("a", {
    href: "/#"
  }, "Breadcrumb 1")), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, {
    href: "#"
  }, "Breadcrumb 2"), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, {
    "data-floating-menu-container": true
  }, /*#__PURE__*/_react.default.createElement(_OverflowMenu.default, null, /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, {
    itemText: "Breadcrumb 3"
  }), /*#__PURE__*/_react.default.createElement(_OverflowMenuItem.default, {
    itemText: "Breadcrumb 4"
  }))), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, {
    href: "#"
  }, "Breadcrumb 5"), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, null, "Breadcrumb 6"));
};

exports.breadcrumbWithOverflowMenu = breadcrumbWithOverflowMenu;

var skeleton = function skeleton() {
  return /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbSkeleton, null);
};

exports.skeleton = skeleton;

var props = function props() {
  return {
    className: 'some-class',
    noTrailingSlash: (0, _addonKnobs.boolean)('No trailing slash (noTrailingSlash)', false),
    isCurrentPage: (0, _addonKnobs.boolean)('Is current page (isCurrentPage)', false),
    onClick: (0, _addonActions.action)('onClick')
  };
};

var playground = function playground() {
  return /*#__PURE__*/_react.default.createElement(_Breadcrumb.Breadcrumb, props(), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, null, /*#__PURE__*/_react.default.createElement("a", {
    href: "/#"
  }, "Breadcrumb 1")), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, {
    href: "#"
  }, "Breadcrumb 2"), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, _extends({
    href: "#"
  }, props()), "Breadcrumb 3"), /*#__PURE__*/_react.default.createElement(_Breadcrumb.BreadcrumbItem, null, "Breadcrumb 4"));
};

exports.playground = playground;