"use strict";

require("carbon-components/scss/components/button/_button.scss");

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@cypress/react");

var _Button = _interopRequireDefault(require("./Button"));

var _iconsReact = require("@carbon/icons-react");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
describe('Button', function () {
  beforeEach(function () {
    (0, _react2.mount)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Button.default, null, "button"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      size: "sm"
    }, "size-sm"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      size: "md"
    }, "size-md"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      size: "lg"
    }, "size-lg"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      size: "xl"
    }, "size-xl"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      size: "sm",
      expressive: true
    }, "expressive size-sm"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      size: "md",
      expressive: true
    }, "expressive size-md"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      size: "lg",
      expressive: true
    }, "expressive size-lg"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      size: "xl",
      expressive: true
    }, "expressive size-xl"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "secondary"
    }, "secondary"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "tertiary"
    }, "tertiary"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "ghost"
    }, "ghost"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "danger",
      dangerDescription: "sample"
    }, "danger"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "danger--tertiary",
      dangerDescription: "sample"
    }, "danger--tertiary"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "danger--ghost",
      dangerDescription: "sample"
    }, "danger--ghost"), /*#__PURE__*/_react.default.createElement(_Button.default, {
      hasIconOnly: true,
      renderIcon: _iconsReact.Add16,
      "data-testid": "icon-only"
    })));
  });
  it('should render', function () {
    // full string match regex syntax ^string$ to prevent collisions
    cy.findByText(/^button$/).should('be.visible');
    cy.findByText(/^size-sm$/).should('be.visible');
    cy.findByText(/^size-md$/).should('be.visible');
    cy.findByText(/^size-lg$/).should('be.visible');
    cy.findByText(/^size-xl$/).should('be.visible');
    cy.findByText(/^expressive size-sm$/).should('be.visible');
    cy.findByText(/^expressive size-md$/).should('be.visible');
    cy.findByText(/^expressive size-lg$/).should('be.visible');
    cy.findByText(/^expressive size-xl$/).should('be.visible');
    cy.findByText(/^secondary$/).should('be.visible');
    cy.findByText(/^tertiary$/).should('be.visible');
    cy.findByText(/^ghost$/).should('be.visible');
    cy.findByText(/^danger$/).should('be.visible');
    cy.findByText(/^danger--tertiary$/).should('be.visible');
    cy.findByText(/^danger--ghost$/).should('be.visible');
    cy.findByTestId('icon-only').should('be.visible'); // snapshots should always be taken _after_ an assertion that
    // a element/component should be visible. This is to ensure
    // the DOM has settled and the element has fully loaded.

    cy.percySnapshot();
  });
});