"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.playground = exports.skeleton = exports.unstable_Checkbox = exports.checkbox = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Checkbox = _interopRequireDefault(require("../Checkbox"));

var _Checkbox2 = _interopRequireDefault(require("../Checkbox/Checkbox.Skeleton"));

var _carbonComponents = require("carbon-components");

var _Checkbox3 = _interopRequireDefault(require("./Checkbox.mdx"));

var _FeatureFlags = require("../FeatureFlags");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var prefix = _carbonComponents.settings.prefix;
var _default = {
  title: 'Components/Checkbox',
  component: _Checkbox.default,
  subcomponents: {
    CheckboxSkeleton: _Checkbox2.default
  },
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    docs: {
      page: _Checkbox3.default
    }
  }
};
exports.default = _default;

var checkbox = function checkbox() {
  return /*#__PURE__*/_react.default.createElement("fieldset", {
    className: "".concat(prefix, "--fieldset")
  }, /*#__PURE__*/_react.default.createElement("legend", {
    className: "".concat(prefix, "--label")
  }, "Checkbox heading"), /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
    labelText: "Checkbox label",
    id: "checkbox-label-1"
  }), /*#__PURE__*/_react.default.createElement(_Checkbox.default, {
    labelText: "Checkbox label",
    id: "checkbox-label-2"
  }));
};

exports.checkbox = checkbox;

var unstable_Checkbox = function unstable_Checkbox() {
  return /*#__PURE__*/_react.default.createElement(_FeatureFlags.FeatureFlags, {
    flags: {
      'enable-v11-release': true
    }
  }, /*#__PURE__*/_react.default.createElement("fieldset", {
    className: "".concat(prefix, "--fieldset")
  }, /*#__PURE__*/_react.default.createElement("legend", {
    className: "".concat(prefix, "--label")
  }, "Checkbox heading"), /*#__PURE__*/_react.default.createElement(_Checkbox.default, _extends({}, props(), {
    labelText: "Checkbox label",
    id: "checkbox-label-1"
  })), /*#__PURE__*/_react.default.createElement(_Checkbox.default, _extends({}, props(), {
    labelText: "Checkbox label",
    id: "checkbox-label-2"
  }))));
};

exports.unstable_Checkbox = unstable_Checkbox;
unstable_Checkbox.story = {
  name: 'unstable_Checkbox'
};

var skeleton = function skeleton() {
  return /*#__PURE__*/_react.default.createElement(_Checkbox2.default, null);
};

exports.skeleton = skeleton;

var props = function props() {
  return {
    checked: (0, _addonKnobs.boolean)('Checked (checked)', false),
    className: 'some-class',
    labelText: (0, _addonKnobs.text)('Label text (labelText)', 'Checkbox label'),
    indeterminate: (0, _addonKnobs.boolean)('Intermediate (indeterminate)', false),
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    hideLabel: (0, _addonKnobs.boolean)('No label (hideLabel)', false),
    wrapperClassName: (0, _addonKnobs.text)('Wrapper CSS class name (wrapperClassName)', ''),
    onChange: (0, _addonActions.action)('onChange')
  };
};

var playground = function playground() {
  return /*#__PURE__*/_react.default.createElement("fieldset", {
    className: "".concat(prefix, "--fieldset")
  }, /*#__PURE__*/_react.default.createElement("legend", {
    className: (0, _classnames.default)("".concat(prefix, "--label"), _defineProperty({}, "".concat(prefix, "--label--disabled"), props().disabled))
  }, "Checkbox heading"), /*#__PURE__*/_react.default.createElement(_Checkbox.default, _extends({}, props(), {
    id: "checkbox-label-1"
  })), /*#__PURE__*/_react.default.createElement(_Checkbox.default, _extends({}, props(), {
    id: "checkbox-label-2"
  })));
};

exports.playground = playground;