"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["className", "type"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function CodeSnippetSkeleton(_ref) {
  var _cx;

  var containerClassName = _ref.className,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'single' : _ref$type,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = (0, _usePrefix.usePrefix)();
  var className = (0, _classnames.default)(containerClassName, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--snippet"), true), _defineProperty(_cx, "".concat(prefix, "--skeleton"), true), _defineProperty(_cx, "".concat(prefix, "--snippet--single"), type === 'single'), _defineProperty(_cx, "".concat(prefix, "--snippet--multi"), type === 'multi'), _cx));

  if (type === 'single') {
    return /*#__PURE__*/_react.default.createElement("div", _extends({
      className: className
    }, rest), /*#__PURE__*/_react.default.createElement("div", {
      className: "".concat(prefix, "--snippet-container")
    }, /*#__PURE__*/_react.default.createElement("span", null)));
  }

  if (type === 'multi') {
    return /*#__PURE__*/_react.default.createElement("div", _extends({
      className: className
    }, rest), /*#__PURE__*/_react.default.createElement("div", {
      className: "".concat(prefix, "--snippet-container")
    }, /*#__PURE__*/_react.default.createElement("span", null), /*#__PURE__*/_react.default.createElement("span", null), /*#__PURE__*/_react.default.createElement("span", null)));
  }
}

CodeSnippetSkeleton.propTypes = {
  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * The type of the code snippet, including single or multi
   */
  type: _propTypes.default.oneOf(['single', 'multi'])
};
var _default = CodeSnippetSkeleton;
exports.default = _default;