"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.light = exports.disabled = exports.Playground = exports.combobox = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _ComboBox = _interopRequireDefault(require("../ComboBox"));

var _ComboBox2 = _interopRequireDefault(require("./ComboBox.mdx"));

var _excluded = ["listBoxMenuIconTranslationIds"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var items = [{
  id: 'option-0',
  text: 'An example option that is really long to show what should be done to handle long text'
}, {
  id: 'option-1',
  text: 'Option 1'
}, {
  id: 'option-2',
  text: 'Option 2'
}, {
  id: 'option-3',
  text: 'Option 3'
}, {
  id: 'option-4',
  text: 'Option 4'
}, {
  id: 'option-5',
  text: 'Option 5'
}];
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var directions = {
  'Bottom (default)': 'bottom',
  'Top ': 'top'
};
var _default = {
  title: 'Components/ComboBox',
  component: _ComboBox.default,
  parameters: {
    docs: {
      page: _ComboBox2.default
    }
  }
};
exports.default = _default;

var combobox = function combobox() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_ComboBox.default, {
    onChange: function onChange() {},
    id: "carbon-combobox",
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter...",
    titleText: "ComboBox title",
    helperText: "Combobox helper text"
  }));
};

exports.combobox = combobox;

var props = function props() {
  return {
    id: (0, _addonKnobs.text)('Combobox ID (id)', 'carbon-combobox-example'),
    placeholder: (0, _addonKnobs.text)('Placeholder text (placeholder)', 'Filter...'),
    titleText: (0, _addonKnobs.text)('Title (titleText)', 'Combobox title'),
    helperText: (0, _addonKnobs.text)('Helper text (helperText)', 'Optional helper text here'),
    light: (0, _addonKnobs.boolean)('Light (light)', false),
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    invalid: (0, _addonKnobs.boolean)('Invalid (invalid)', false),
    invalidText: (0, _addonKnobs.text)('Invalid text (invalidText)', 'A valid value is required'),
    size: (0, _addonKnobs.select)('Field size (size)', sizes, undefined) || undefined,
    direction: (0, _addonKnobs.select)('Dropdown direction (direction)', directions, 'bottom'),
    onChange: (0, _addonActions.action)('onChange'),
    onToggleClick: (0, _addonActions.action)('onClick'),
    warn: (0, _addonKnobs.boolean)('Show warning state (warn)', false),
    warnText: (0, _addonKnobs.text)('Warning state text (warnText)', 'This mode may perform worse on older machines'),
    listBoxMenuIconTranslationIds: (0, _addonKnobs.object)('Listbox menu icon translation IDs (for translateWithId callback)', {
      'close.menu': 'Close menu',
      'open.menu': 'Open menu',
      'clear.selection': 'Clear selection'
    })
  };
};

var Playground = function Playground() {
  var _props = props(),
      listBoxMenuIconTranslationIds = _props.listBoxMenuIconTranslationIds,
      comboBoxProps = _objectWithoutProperties(_props, _excluded);

  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_ComboBox.default, _extends({}, comboBoxProps, {
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    translateWithId: function translateWithId(id) {
      return listBoxMenuIconTranslationIds[id];
    }
  })));
};

exports.Playground = Playground;

var disabled = function disabled() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_ComboBox.default, {
    onChange: function onChange() {},
    id: "carbon-combobox-disabled",
    disabled: true,
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter...",
    titleText: "ComboBox title",
    helperText: "Combobox helper text"
  }));
};

exports.disabled = disabled;

var light = function light() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_ComboBox.default, {
    onChange: function onChange() {},
    id: "carbon-combobox-light",
    light: true,
    items: items,
    itemToString: function itemToString(item) {
      return item ? item.text : '';
    },
    placeholder: "Filter...",
    titleText: "ComboBox title",
    helperText: "Combobox helper text"
  }));
};

exports.light = light;