"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithRadioSelection = exports.Usage = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _DataTable = _interopRequireWildcard(require("../../DataTable"));

var _shared = require("./shared");

var _DataTable2 = _interopRequireDefault(require("../DataTable.mdx"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var _default = {
  title: 'Components/DataTable/Selection',
  component: _DataTable.default,
  subcomponents: {
    TableSelectAll: _DataTable.TableSelectAll,
    TableSelectRow: _DataTable.TableSelectRow,
    Table: _DataTable.Table,
    TableBody: _DataTable.TableBody,
    TableCell: _DataTable.TableCell,
    TableContainer: _DataTable.TableContainer,
    TableHead: _DataTable.TableHead,
    TableHeader: _DataTable.TableHeader,
    TableRow: _DataTable.TableRow
  },
  parameters: {
    docs: {
      page: _DataTable2.default
    }
  }
};
exports.default = _default;

var Usage = function Usage() {
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, {
    rows: _shared.rows,
    headers: _shared.headers
  }, function (_ref) {
    var rows = _ref.rows,
        headers = _ref.headers,
        getHeaderProps = _ref.getHeaderProps,
        getRowProps = _ref.getRowProps,
        getSelectionProps = _ref.getSelectionProps,
        getTableProps = _ref.getTableProps,
        getTableContainerProps = _ref.getTableContainerProps;
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, _extends({
      title: "DataTable",
      description: "With selection"
    }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.Table, getTableProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableSelectAll, getSelectionProps()), headers.map(function (header, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, _extends({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, _extends({
        key: i
      }, getRowProps({
        row: row
      })), /*#__PURE__*/_react.default.createElement(_DataTable.TableSelectRow, getSelectionProps({
        row: row
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
          key: cell.id
        }, cell.value);
      }));
    }))));
  });
};

exports.Usage = Usage;

var WithRadioSelection = function WithRadioSelection() {
  return /*#__PURE__*/_react.default.createElement(_DataTable.default, {
    rows: _shared.rows,
    headers: _shared.headers,
    radio: true
  }, function (_ref2) {
    var rows = _ref2.rows,
        headers = _ref2.headers,
        getHeaderProps = _ref2.getHeaderProps,
        getRowProps = _ref2.getRowProps,
        getSelectionProps = _ref2.getSelectionProps,
        getTableProps = _ref2.getTableProps,
        getTableContainerProps = _ref2.getTableContainerProps;
    return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, _extends({
      title: "DataTable",
      description: "With radio selection"
    }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.Table, getTableProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, /*#__PURE__*/_react.default.createElement("th", {
      scope: "col"
    }), headers.map(function (header, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, _extends({
        key: i
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row, i) {
      return /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, _extends({
        key: i
      }, getRowProps({
        row: row
      })), /*#__PURE__*/_react.default.createElement(_DataTable.TableSelectRow, getSelectionProps({
        row: row
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
          key: cell.id
        }, cell.value);
      }));
    }))));
  });
};

exports.WithRadioSelection = WithRadioSelection;