"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Example = exports.default = void 0;

require("./story.scss");

var _react = _interopRequireDefault(require("react"));

var _addonKnobs = require("@storybook/addon-knobs");

var _iconsReact = require("@carbon/icons-react");

var _DataTable = _interopRequireWildcard(require("../../../DataTable"));

var _shared = require("../shared");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

var sizes = {
  Compact: 'compact',
  Short: 'short',
  Medium: 'md',
  Default: null,
  Tall: 'tall'
};
var tableProps = {
  sizeProp: function sizeProp() {
    return {
      size: (0, _addonKnobs.select)('Row size (size)', sizes, null)
    };
  }
};
var _default = {
  title: 'Components/DataTable/Development',
  decorators: [_addonKnobs.withKnobs]
};
exports.default = _default;

var Example = function Example(props) {
  var insertInRandomPosition = function insertInRandomPosition(array, element) {
    var index = Math.floor(Math.random() * (array.length + 1));
    return [].concat(_toConsumableArray(array.slice(0, index)), [element], _toConsumableArray(array.slice(index)));
  };

  var DynamicRows = /*#__PURE__*/function (_React$Component) {
    _inherits(DynamicRows, _React$Component);

    var _super = _createSuper(DynamicRows);

    function DynamicRows() {
      var _this;

      _classCallCheck(this, DynamicRows);

      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      _this = _super.call.apply(_super, [this].concat(args));

      _defineProperty(_assertThisInitialized(_this), "state", {
        rows: _shared.rows,
        headers: _shared.headers,
        id: 0
      });

      _defineProperty(_assertThisInitialized(_this), "handleOnHeaderAdd", function () {
        var length = _this.state.headers.length;
        var header = {
          key: "header_".concat(length),
          header: "Header ".concat(length)
        };

        _this.setState(function (state) {
          var rows = state.rows.map(function (row) {
            return _objectSpread(_objectSpread({}, row), {}, _defineProperty({}, header.key, header.header));
          });
          return {
            rows: rows,
            headers: state.headers.concat(header)
          };
        });
      });

      _defineProperty(_assertThisInitialized(_this), "handleOnRowAdd", function () {
        _this.setState(function (state) {
          var _id = state.id,
              rows = state.rows;
          var id = _id + 1;
          var row = {
            id: '' + id,
            name: "New Row ".concat(id),
            protocol: 'HTTP',
            port: id * 100,
            rule: id % 2 === 0 ? 'Round robin' : 'DNS delegation',
            attached_groups: "Row ".concat(id, "'s VM Groups"),
            status: 'Starting'
          };
          state.headers.filter(function (header) {
            return row[header.key] === undefined;
          }).forEach(function (header) {
            row[header.key] = header.header;
          });
          return {
            id: id,
            rows: insertInRandomPosition(rows, row)
          };
        });
      });

      return _this;
    }

    _createClass(DynamicRows, [{
      key: "render",
      value: function render() {
        var _this2 = this;

        var sizeProp = tableProps.sizeProp();
        return /*#__PURE__*/_react.default.createElement(_DataTable.default, _extends({
          rows: this.state.rows,
          headers: this.state.headers
        }, this.props, {
          render: function render(_ref) {
            var rows = _ref.rows,
                headers = _ref.headers,
                getHeaderProps = _ref.getHeaderProps,
                getSelectionProps = _ref.getSelectionProps,
                getToolbarProps = _ref.getToolbarProps,
                getBatchActionProps = _ref.getBatchActionProps,
                getRowProps = _ref.getRowProps,
                onInputChange = _ref.onInputChange,
                selectedRows = _ref.selectedRows,
                getTableProps = _ref.getTableProps,
                getTableContainerProps = _ref.getTableContainerProps;
            return /*#__PURE__*/_react.default.createElement(_DataTable.TableContainer, _extends({
              title: "DataTable",
              description: "Use the toolbar menu to add rows and headers"
            }, getTableContainerProps()), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbar, getToolbarProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableBatchActions, getBatchActionProps(), /*#__PURE__*/_react.default.createElement(_DataTable.TableBatchAction, {
              renderIcon: _iconsReact.Delete16,
              iconDescription: "Delete the selected rows",
              onClick: (0, _shared.batchActionClick)(selectedRows)
            }, "Delete"), /*#__PURE__*/_react.default.createElement(_DataTable.TableBatchAction, {
              renderIcon: _iconsReact.Save16,
              iconDescription: "Save the selected rows",
              onClick: (0, _shared.batchActionClick)(selectedRows)
            }, "Save"), /*#__PURE__*/_react.default.createElement(_DataTable.TableBatchAction, {
              renderIcon: _iconsReact.Download16,
              iconDescription: "Download the selected rows",
              onClick: (0, _shared.batchActionClick)(selectedRows)
            }, "Download")), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarContent, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarSearch, {
              onChange: onInputChange
            }), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarMenu, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarAction, {
              onClick: _this2.handleOnRowAdd
            }, "Add row"), /*#__PURE__*/_react.default.createElement(_DataTable.TableToolbarAction, {
              onClick: _this2.handleOnHeaderAdd
            }, "Add header")))), /*#__PURE__*/_react.default.createElement(_DataTable.Table, _extends({}, getTableProps(), sizeProp), /*#__PURE__*/_react.default.createElement(_DataTable.TableHead, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableRow, null, /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandHeader, null), /*#__PURE__*/_react.default.createElement(_DataTable.TableSelectAll, getSelectionProps()), headers.map(function (header, i) {
              return /*#__PURE__*/_react.default.createElement(_DataTable.TableHeader, _extends({
                key: i
              }, getHeaderProps({
                header: header
              })), header.header);
            }))), /*#__PURE__*/_react.default.createElement(_DataTable.TableBody, null, rows.map(function (row) {
              return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
                key: row.id
              }, /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandRow, getRowProps({
                row: row
              }), /*#__PURE__*/_react.default.createElement(_DataTable.TableSelectRow, getSelectionProps({
                row: row
              })), row.cells.map(function (cell) {
                return /*#__PURE__*/_react.default.createElement(_DataTable.TableCell, {
                  key: cell.id
                }, cell.value);
              })), /*#__PURE__*/_react.default.createElement(_DataTable.TableExpandedRow, {
                colSpan: headers.length + 3,
                className: "demo-expanded-td"
              }, /*#__PURE__*/_react.default.createElement("h6", null, "Expandable row content"), /*#__PURE__*/_react.default.createElement("div", null, "Description here")));
            }))));
          }
        }));
      }
    }]);

    return DynamicRows;
  }(_react.default.Component);

  return /*#__PURE__*/_react.default.createElement(DynamicRows, props);
};

exports.Example = Example;