"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonKnobs = require("@storybook/addon-knobs");

var _DataTableSkeleton = _interopRequireDefault(require("../DataTableSkeleton"));

var _shared = require("../DataTable/stories/shared");

var _excluded = ["showHeaders"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var props = function props() {
  return {
    showHeaders: (0, _addonKnobs.boolean)('Show table headers', true),
    zebra: (0, _addonKnobs.boolean)('Use zebra stripe (zebra)', false),
    compact: (0, _addonKnobs.boolean)('Compact variant (compact)', false),
    showHeader: (0, _addonKnobs.boolean)('Show the Table Header (showHeader)', true),
    showToolbar: (0, _addonKnobs.boolean)('Show the Table Toolbar (showToolbar)', true)
  };
};

var _default = {
  title: 'Components/DataTable',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _DataTableSkeleton.default
  }
};
exports.default = _default;

var Skeleton = function Skeleton() {
  var _props = props(),
      showHeaders = _props.showHeaders,
      rest = _objectWithoutProperties(_props, _excluded);

  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '800px'
    }
  }, /*#__PURE__*/_react.default.createElement(_DataTableSkeleton.default, _extends({}, rest, {
    headers: showHeaders ? _shared.headers : null
  })), /*#__PURE__*/_react.default.createElement("br", null));
};

exports.Skeleton = Skeleton;
Skeleton.storyName = 'default';
Skeleton.parameters = {
  info: {
    text: "\n        Skeleton states are used as a progressive loading state while the user waits for content to load.\n\n        This example shows a skeleton state for a data table.\n      "
  }
};