"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.DatePickerPlayground = exports.Range = exports.Single = exports.Simple = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonKnobs = require("@storybook/addon-knobs");

var _addonActions = require("@storybook/addon-actions");

var _DatePicker = _interopRequireDefault(require("../DatePicker"));

var _DatePickerInput = _interopRequireDefault(require("../DatePickerInput"));

var _DatePicker2 = _interopRequireDefault(require("../DatePicker/DatePicker.Skeleton"));

var _DatePicker3 = _interopRequireDefault(require("./DatePicker.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var patterns = {
  'Short (d{1,2}/d{4})': '\\d{1,2}/\\d{4}',
  'Regular (d{1,2}/d{1,2}/d{4})': '\\d{1,2}/\\d{1,2}/\\d{4}'
};
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var types = {
  Simple: 'simple',
  Single: 'single',
  Range: 'range'
};
var props = {
  datePicker: function datePicker() {
    return {
      dateFormat: (0, _addonKnobs.text)('The date format (dateFormat in <DatePicker>)', 'm/d/Y'),
      id: 'date-picker',
      light: (0, _addonKnobs.boolean)('Light variant (light in <DatePicker>)', false),
      datePickerType: (0, _addonKnobs.select)('Date Picker Type (datePickerType)', types, 'single'),
      minDate: (0, _addonKnobs.text)('Disable dates before this date (minDate)', '11/15/2020'),
      maxDate: (0, _addonKnobs.text)('Disabled dates after this date (maxDate)', '11/01/2040'),
      disable: (0, _addonKnobs.array)('Disable specific dates (disable)', ['07/15/2021'], ','),
      onClose: (0, _addonActions.action)('onClose'),
      onOpen: (0, _addonActions.action)('onOpen'),
      onChange: (0, _addonActions.action)('onChange')
    };
  },
  datePickerInput: function datePickerInput() {
    return {
      id: 'date-picker-input-id',
      className: 'some-class',
      size: (0, _addonKnobs.select)('Field size (size)', sizes, undefined) || undefined,
      labelText: (0, _addonKnobs.text)('Label text (labelText in <DatePickerInput>)', 'Date Picker label'),
      pattern: (0, _addonKnobs.select)('The date format (pattern in <DatePickerInput>)', patterns, 'd{1,2}/d{4}'),
      placeholder: (0, _addonKnobs.text)('Placeholder text (placeholder in <DatePickerInput>)', 'mm/dd/yyyy'),
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled in <DatePickerInput>)', false),
      helperText: (0, _addonKnobs.text)('Helper text (helperText)', 'Optional help text'),
      invalid: (0, _addonKnobs.boolean)('Show form validation UI (invalid in <DatePickerInput>)', false),
      invalidText: (0, _addonKnobs.text)('Form validation UI content (invalidText in <DatePickerInput>)', 'A valid date is required'),
      warn: (0, _addonKnobs.boolean)('Show warning state (warn)', false),
      warnText: (0, _addonKnobs.text)('Warning state text (warnText)', 'Selected dates may cause conflicts'),
      iconDescription: (0, _addonKnobs.text)('Icon description (iconDescription in <DatePickerInput>)', 'Icon description'),
      onChange: (0, _addonActions.action)('onChange')
    };
  }
};
var _default = {
  title: 'Components/DatePicker',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _DatePicker.default,
    subcomponents: {
      DatePickerInput: _DatePickerInput.default,
      DatePickerSkeleton: _DatePicker2.default
    },
    docs: {
      page: _DatePicker3.default
    }
  }
};
exports.default = _default;

var Simple = function Simple() {
  return /*#__PURE__*/_react.default.createElement(_DatePicker.default, {
    datePickerType: "simple"
  }, /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-simple"
  }));
};

exports.Simple = Simple;
Simple.storyName = 'simple';

var Single = function Single() {
  return /*#__PURE__*/_react.default.createElement(_DatePicker.default, {
    datePickerType: "single"
  }, /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-single"
  }));
};

exports.Single = Single;
Single.storyName = 'single with calendar';

var Range = function Range() {
  return /*#__PURE__*/_react.default.createElement(_DatePicker.default, {
    datePickerType: "range"
  }, /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    id: "date-picker-input-id-start",
    placeholder: "mm/dd/yyyy",
    labelText: "Start date"
  }), /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, {
    id: "date-picker-input-id-finish",
    placeholder: "mm/dd/yyyy",
    labelText: "End date"
  }));
};

exports.Range = Range;
Range.storyName = 'range with calendar';

var DatePickerPlayground = function DatePickerPlayground() {
  return /*#__PURE__*/_react.default.createElement(_DatePicker.default, props.datePicker(), /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, props.datePickerInput()), props.datePicker().datePickerType === 'range' && /*#__PURE__*/_react.default.createElement(_DatePickerInput.default, _extends({}, props.datePickerInput(), {
    id: "date-picker-input-2"
  })));
};

exports.DatePickerPlayground = DatePickerPlayground;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement(_DatePicker2.default, {
    range: true
  });
};

exports.Skeleton = Skeleton;
Skeleton.storyName = 'skeleton';