"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Dialog = void 0;

require("wicg-inert");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _FocusScope = require("../FocusScope");

var _useMergedRefs = require("../../internal/useMergedRefs");

var _useSavedCallback = require("../../internal/useSavedCallback");

var _keyboard = require("../../internal/keyboard");

var _excluded = ["aria-labelledby", "children", "onDismiss"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/**
 * @see https://www.tpgi.com/the-current-state-of-modal-dialog-accessibility/
 */
var Dialog = /*#__PURE__*/_react.default.forwardRef(function Dialog(props, forwardRef) {
  var labelledBy = props['aria-labelledby'],
      children = props.children,
      onDismiss = props.onDismiss,
      rest = _objectWithoutProperties(props, _excluded);

  var dialogRef = (0, _react.useRef)(null);
  var ref = (0, _useMergedRefs.useMergedRefs)([dialogRef, forwardRef]);
  var savedOnDismiss = (0, _useSavedCallback.useSavedCallback)(onDismiss);

  function onKeyDown(event) {
    if ((0, _keyboard.match)(event, _keyboard.keys.Escape)) {
      event.stopPropagation();
      savedOnDismiss();
    }
  }

  (0, _react.useEffect)(function () {
    var changes = hide(document.body, dialogRef.current);
    return function () {
      show(changes);
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_FocusScope.FocusScope, _extends({}, rest, {
    "aria-labelledby": labelledBy,
    "aria-modal": "true",
    initialFocusRef: dialogRef,
    onKeyDown: onKeyDown,
    ref: ref,
    role: "dialog",
    tabIndex: "-1"
  }), children);
});

exports.Dialog = Dialog;
Dialog.propTypes = {
  /**
   * Provide the associated element that labels the Dialog
   */
  'aria-labelledby': _propTypes.default.string.isRequired,

  /**
   * Provide children to be rendered inside of the Dialog
   */
  children: _propTypes.default.node,

  /**
   * Provide a handler that is called when the Dialog is requesting to be closed
   */
  onDismiss: _propTypes.default.func.isRequired
};

if (process.env.NODE_ENV !== "production") {
  Dialog.displayName = 'Dialog';
}

function hide(root, dialog) {
  var changes = [];
  var queue = Array.from(root.childNodes);

  while (queue.length !== 0) {
    var node = queue.shift();

    if (node.nodeType !== Node.ELEMENT_NODE) {
      continue;
    } // If a node is the dialog, do nothing


    if (node === dialog) {
      continue;
    } // If a tree contains our dialog, traverse its children


    if (node.contains(dialog)) {
      queue.push.apply(queue, _toConsumableArray(Array.from(node.childNodes)));
      continue;
    } // If a node is a bumper, do nothing


    if (node.hasAttribute('data-carbon-focus-scope') && (dialog.previousSibling === node || dialog.nextSibling === node)) {
      continue;
    }

    if (node.getAttribute('aria-hidden') === 'true') {
      continue;
    }

    if (node.hasAttribute('inert')) {
      continue;
    }

    if (node.getAttribute('aria-hidden') === 'false') {
      node.setAttribute('aria-hidden', 'true');
      node.setAttribute('inert', '');
      changes.push({
        node: node,
        attributes: {
          'aria-hidden': 'false'
        }
      });
      continue;
    } // Otherwise, set it to inert and set aria-hidden to true


    node.setAttribute('aria-hidden', 'true');
    node.setAttribute('inert', '');
    changes.push({
      node: node
    });
  }

  return changes;
}

function show(changes) {
  changes.forEach(function (_ref) {
    var node = _ref.node,
        attributes = _ref.attributes;
    node.removeAttribute('inert'); // This mutation needs to be asynchronous to allow the polyfill time to
    // observe the change and allow mutations to occur
    // https://github.com/WICG/inert#performance-and-gotchas

    setTimeout(function () {
      if (attributes && attributes['aria-hidden']) {
        node.setAttribute('aria-hidden', attributes['aria-hidden']);
      } else {
        node.removeAttribute('aria-hidden');
      }
    }, 0);
  });
}