"use strict";

require("carbon-components/scss/components/dropdown/_dropdown.scss");

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@cypress/react");

var _testHelpers = require("../ListBox/test-helpers");

var _Dropdown = _interopRequireDefault(require("../Dropdown"));

var _Dropdown2 = _interopRequireDefault(require("../Dropdown/Dropdown.Skeleton"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
describe('Dropdown', function () {
  beforeEach(function () {
    var items = (0, _testHelpers.generateItems)(5, _testHelpers.generateGenericItem);
    var label = 'Dropdown menu options';
    var style = {
      marginBottom: '1rem'
    };
    (0, _react2.mount)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
      style: {
        marginBottom: '14rem'
      },
      items: items,
      label: label
    }), /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
      style: style,
      items: items,
      label: label,
      size: "sm"
    }), /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
      style: style,
      items: items,
      label: label,
      size: "md"
    }), /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
      style: style,
      items: items,
      label: label,
      size: "lg"
    }), /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
      style: style,
      items: items,
      label: label,
      size: "xl"
    }), /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
      style: style,
      items: items,
      label: label,
      disabled: true
    }), /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
      style: style,
      items: items,
      label: label,
      helperText: "This is helper text"
    }), /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
      style: style,
      items: items,
      label: label,
      warn: true
    }), /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
      style: style,
      items: items,
      label: label,
      warn: true,
      warnText: "This is warn text"
    }), /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
      style: style,
      items: items,
      label: label,
      invalid: true,
      invalidText: "This is invalid text"
    }), /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
      style: style,
      items: items,
      label: label,
      light: true
    }), /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
      style: style,
      items: items,
      label: label,
      light: true,
      invalid: true,
      invalidText: "This is invalid text"
    }), /*#__PURE__*/_react.default.createElement(_Dropdown.default, {
      style: style,
      items: items,
      label: label,
      type: "inline"
    }), /*#__PURE__*/_react.default.createElement(_Dropdown2.default, {
      style: style,
      size: "sm"
    }), /*#__PURE__*/_react.default.createElement(_Dropdown2.default, {
      style: style,
      size: "md"
    }), /*#__PURE__*/_react.default.createElement(_Dropdown2.default, {
      style: style,
      size: "lg"
    }), /*#__PURE__*/_react.default.createElement(_Dropdown2.default, {
      style: style,
      size: "xl"
    })));
  });
  it('should render', function () {
    cy.findAllByText(/Dropdown menu options/).should('have.length', 13).last().should('be.visible'); // snapshots should always be taken _after_ an assertion that
    // a element/component should be visible. This is to ensure
    // the DOM has settled and the element has fully loaded.

    cy.percySnapshot();
  });
  it('should render listbox when clicked', function () {
    cy.findAllByText(/Dropdown menu options/).first().click();
    cy.findAllByText(/Item 0/).first().should('be.visible');
    cy.findAllByText(/Item 4/).first().should('be.visible'); // snapshots should always be taken _after_ an assertion that
    // a element/component should be visible. This is to ensure
    // the DOM has settled and the element has fully loaded.

    cy.percySnapshot();
  });
});