"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAutoFocus = useAutoFocus;

var _react = require("react");

var _focus = require("../../internal/focus");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
function useAutoFocus(getElementOrRef) {
  var callbackRef = (0, _react.useRef)(getElementOrRef);
  (0, _react.useEffect)(function () {
    if (callbackRef.current) {
      var elementOrRef = callbackRef.current();
      var element = elementOrRef.current || elementOrRef;

      if (element) {
        (0, _focus.focus)(element);
      }
    }
  }, []);
}