"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UxExample = exports._InlineLoading = exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Button = _interopRequireDefault(require("../Button"));

var _InlineLoading2 = _interopRequireDefault(require("../InlineLoading"));

var _InlineLoading3 = _interopRequireDefault(require("./InlineLoading.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var props = function props() {
  return {
    status: (0, _addonKnobs.select)('Loading status (status)', ['inactive', 'active', 'finished', 'error'], 'active'),
    iconDescription: (0, _addonKnobs.text)('Icon description (iconDescription)', 'Active loading indicator'),
    description: (0, _addonKnobs.text)('Loading progress description (description)', 'Loading data...'),
    successDelay: (0, _addonKnobs.number)('The duration for successful state before `onSuccess` fires (successDelay)', 1500),
    onSuccess: (0, _addonActions.action)('onSuccess')
  };
};

var _default = {
  title: 'Components/InlineLoading',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _InlineLoading2.default,
    docs: {
      page: _InlineLoading3.default
    }
  }
};
exports.default = _default;

var _InlineLoading = function _InlineLoading() {
  return /*#__PURE__*/_react.default.createElement(_InlineLoading2.default, props());
};

exports._InlineLoading = _InlineLoading;
_InlineLoading.storyName = 'Inline loading';
_InlineLoading.parameters = {
  info: {
    text: "\n            Inline Loading spinners are used when creating, updating, or deleting an item.\n            They help notify users that their change is underway, with different states for 'loading' and 'success'.\n          "
  }
};

var UxExample = function UxExample() {
  function MockSubmission(_ref) {
    var children = _ref.children;

    var _useState = (0, _react.useState)(false),
        _useState2 = _slicedToArray(_useState, 2),
        isSubmitting = _useState2[0],
        setIsSubmitting = _useState2[1];

    var _useState3 = (0, _react.useState)(false),
        _useState4 = _slicedToArray(_useState3, 2),
        success = _useState4[0],
        setSuccess = _useState4[1];

    var _useState5 = (0, _react.useState)('Submitting...'),
        _useState6 = _slicedToArray(_useState5, 2),
        description = _useState6[0],
        setDescription = _useState6[1];

    var _useState7 = (0, _react.useState)('off'),
        _useState8 = _slicedToArray(_useState7, 2),
        ariaLive = _useState8[0],
        setAriaLive = _useState8[1];

    var handleSubmit = function handleSubmit() {
      setIsSubmitting(true);
      setAriaLive('assertive'); // Instead of making a real request, we mock it with a timer

      setTimeout(function () {
        setIsSubmitting(false);
        setSuccess(true);
        setDescription('Submitted!'); // To make submittable again, we reset the state after a bit so the user gets completion feedback

        setTimeout(function () {
          setSuccess(false);
          setDescription('Submitting...');
          setAriaLive('off');
        }, 1500);
      }, 2000);
    };

    return children({
      handleSubmit: handleSubmit,
      isSubmitting: isSubmitting,
      success: success,
      description: description,
      ariaLive: ariaLive
    });
  }

  MockSubmission.displayName = 'InlineLoading';
  MockSubmission.__docgenInfo = _objectSpread(_objectSpread({}, _InlineLoading2.default.__docgenInfo), {}, {
    props: _objectSpread({}, _InlineLoading2.default.__docgenInfo.props)
  });
  return /*#__PURE__*/_react.default.createElement(MockSubmission, null, function (_ref2) {
    var handleSubmit = _ref2.handleSubmit,
        isSubmitting = _ref2.isSubmitting,
        success = _ref2.success,
        description = _ref2.description,
        ariaLive = _ref2.ariaLive;
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        display: 'flex',
        width: '300px'
      }
    }, /*#__PURE__*/_react.default.createElement(_Button.default, {
      kind: "secondary",
      disabled: isSubmitting || success
    }, "Cancel"), isSubmitting || success ? /*#__PURE__*/_react.default.createElement(_InlineLoading2.default, {
      style: {
        marginLeft: '1rem'
      },
      description: description,
      status: success ? 'finished' : 'active',
      "aria-live": ariaLive
    }) : /*#__PURE__*/_react.default.createElement(_Button.default, {
      onClick: handleSubmit
    }, "Submit"));
  });
};

exports.UxExample = UxExample;
UxExample.storyName = 'UX example';
UxExample.parameters = {
  info: {
    text: "\n        This is a full example of how to leverage the <InlineLoading /> component to create a nice user experience when submitting a form.\n\n        For the full source code of this example, check out the 'story' panel below.\n      "
  }
};