"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayoutDirection = LayoutDirection;
Object.defineProperty(exports, "LayoutDirectionContext", {
  enumerable: true,
  get: function get() {
    return _LayoutDirectionContext.LayoutDirectionContext;
  }
});

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _LayoutDirectionContext = require("./LayoutDirectionContext");

var _excluded = ["as", "children", "dir"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function LayoutDirection(_ref) {
  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'div' : _ref$as,
      children = _ref.children,
      dir = _ref.dir,
      rest = _objectWithoutProperties(_ref, _excluded);

  var value = _react.default.useMemo(function () {
    return {
      direction: dir
    };
  }, [dir]);

  return /*#__PURE__*/_react.default.createElement(_LayoutDirectionContext.LayoutDirectionContext.Provider, {
    value: value
  }, /*#__PURE__*/_react.default.createElement(BaseComponent, _extends({
    dir: dir
  }, rest), children));
}

LayoutDirection.propTypes = {
  /**
   * Customize the element type used to render the outermost node
   */
  as: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.string, _propTypes.default.elementType]),

  /**
   * Provide child elements or components to be rendered inside of this
   * component
   */
  children: _propTypes.default.node,

  /**
   * Specify the layout direction of this part of the page
   */
  dir: _propTypes.default.oneOf(['ltr', 'rtl']).isRequired
};