"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Playground = exports.PairedWithIcon = exports._Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _iconsReact = require("@carbon/icons-react");

var _Link = _interopRequireDefault(require("../Link"));

var _Link2 = _interopRequireDefault(require("./Link.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable no-console */
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};

var props = function props() {
  return {
    className: 'some-class',
    href: (0, _addonKnobs.text)('The link href (href)', '#'),
    inline: (0, _addonKnobs.boolean)('Use the in-line variant (inline)', false),
    visited: (0, _addonKnobs.boolean)('Allow visited styles', false),
    onClick: function (handler) {
      return function (evt) {
        evt.preventDefault(); // Prevent link from being followed for demo purpose

        handler(evt);
      };
    }((0, _addonActions.action)('onClick')),
    disabled: (0, _addonKnobs.boolean)('Disabled', false),
    size: (0, _addonKnobs.select)('Field size (size)', sizes, undefined) || undefined
  };
};

var _default = {
  title: 'Components/Link',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _Link.default,
    docs: {
      page: _Link2.default
    }
  }
};
exports.default = _default;

var _Default = function _Default() {
  return /*#__PURE__*/_react.default.createElement(_Link.default, {
    href: "http://www.carbondesignsystem.com"
  }, "Link");
};

exports._Default = _Default;
_Default.story = {
  name: 'Link'
};

var PairedWithIcon = function PairedWithIcon() {
  return /*#__PURE__*/_react.default.createElement(_Link.default, {
    href: "http://www.carbondesignsystem.com",
    renderIcon: _iconsReact.Download16
  }, "Download");
};

exports.PairedWithIcon = PairedWithIcon;

var Playground = function Playground() {
  return /*#__PURE__*/_react.default.createElement(_Link.default, props(), "Link");
};

exports.Playground = Playground;