"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._PaginationNav = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _PaginationNav2 = _interopRequireDefault(require("../PaginationNav"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var props = function props() {
  return {
    loop: (0, _addonKnobs.boolean)('Allow user to loop through the items when reaching first / last (loop)', false),
    page: (0, _addonKnobs.number)('The current page (page)', 0),
    totalItems: (0, _addonKnobs.number)('Total number of items (totalItems)', 10),
    itemsShown: (0, _addonKnobs.number)('Number of items to be shown (minimum 4) (itemsShown)', 10),
    onChange: (0, _addonActions.action)('onChange')
  };
};

var _default = {
  title: 'Components/PaginationNav',
  decorators: [_addonKnobs.withKnobs, function (story) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '800px'
      }
    }, story());
  }],
  parameters: {
    component: _PaginationNav2.default
  }
};
exports.default = _default;

var _PaginationNav = function _PaginationNav() {
  return /*#__PURE__*/_react.default.createElement(_PaginationNav2.default, props());
};

exports._PaginationNav = _PaginationNav;
_PaginationNav.storyName = 'PaginationNav';
_PaginationNav.parameters = {
  info: {
    text: "\n        Pagination Nav is a group of pagination buttons.\n          "
  }
};