"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Portal = Portal;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = require("react");

var _reactDom = _interopRequireDefault(require("react-dom"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * Helper component for rendering content within a portal. By default, the
 * portal will render into document.body. You can customize this behavior with
 * the `container` prop. Any `children` provided to this component will be
 * rendered inside of the container.
 */
function Portal(_ref) {
  var container = _ref.container,
      children = _ref.children;

  var _useState = (0, _react.useState)(null),
      _useState2 = _slicedToArray(_useState, 2),
      mountNode = _useState2[0],
      setMountNode = _useState2[1];

  (0, _react.useEffect)(function () {
    setMountNode(container ? container.current : document.body);
  }, [container]);

  if (mountNode) {
    return /*#__PURE__*/_reactDom.default.createPortal(children, mountNode);
  }

  return null;
}

Portal.propTypes = {
  /**
   * Specify the children elements to be rendered inside of the <Portal>
   */
  children: _propTypes.default.node,

  /**
   * Provide a ref for a container node to render the portal
   */
  container: _propTypes.default.oneOfType([_propTypes.default.shape({
    current: _propTypes.default.any
  })])
};