"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.Interactive = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonKnobs = require("@storybook/addon-knobs");

var _addonActions = require("@storybook/addon-actions");

var _ProgressIndicator = require("../ProgressIndicator");

var _ProgressIndicator2 = _interopRequireDefault(require("../ProgressIndicator/ProgressIndicator.Skeleton"));

var _Tooltip = _interopRequireDefault(require("../Tooltip"));

var _carbonComponents = require("carbon-components");

var _ProgressIndicator3 = _interopRequireDefault(require("./ProgressIndicator.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var prefix = _carbonComponents.settings.prefix;
var _default = {
  title: 'Components/ProgressIndicator',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _ProgressIndicator.ProgressIndicator,
    docs: {
      page: _ProgressIndicator3.default
    },
    subcomponents: {
      ProgressStep: _ProgressIndicator.ProgressStep
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_ProgressIndicator.ProgressIndicator, {
    vertical: (0, _addonKnobs.boolean)('Vertical (vertical)', false),
    currentIndex: (0, _addonKnobs.number)('Current progress (currentIndex)', 1),
    spaceEqually: (0, _addonKnobs.boolean)('Space Equally (spaceEqually)', false)
  }, /*#__PURE__*/_react.default.createElement(_ProgressIndicator.ProgressStep, {
    label: (0, _addonKnobs.text)('Label (label)', 'First step'),
    description: "Step 1: Getting started with Carbon Design System",
    secondaryLabel: "Optional label"
  }), /*#__PURE__*/_react.default.createElement(_ProgressIndicator.ProgressStep, {
    label: "Second step with tooltip",
    description: "Step 2: Getting started with Carbon Design System",
    renderLabel: function renderLabel() {
      return /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
        direction: "bottom",
        showIcon: false,
        triggerClassName: "".concat(prefix, "--progress-label"),
        triggerText: 'Second step with tooltip',
        tooltipId: "tooltipId-0"
      }, /*#__PURE__*/_react.default.createElement("p", null, "Overflow tooltip content."));
    }
  }), /*#__PURE__*/_react.default.createElement(_ProgressIndicator.ProgressStep, {
    label: "Third step with tooltip",
    description: "Step 3: Getting started with Carbon Design System",
    renderLabel: function renderLabel() {
      return /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
        direction: "bottom",
        showIcon: false,
        triggerClassName: "".concat(prefix, "--progress-label"),
        triggerText: 'Third step with tooltip',
        tooltipId: "tooltipId-1"
      }, /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor, sit amet consectetur adipisicing elit. Animi consequuntur hic ratione aliquid cupiditate, nesciunt saepe iste blanditiis cumque maxime tenetur veniam est illo deserunt sint quae pariatur. Laboriosam, consequatur."));
    }
  }), /*#__PURE__*/_react.default.createElement(_ProgressIndicator.ProgressStep, {
    label: "Fourth step",
    description: "Step 4: Getting started with Carbon Design System",
    invalid: true,
    secondaryLabel: "Example invalid step"
  }), /*#__PURE__*/_react.default.createElement(_ProgressIndicator.ProgressStep, {
    label: "Fifth step",
    description: "Step 5: Getting started with Carbon Design System",
    disabled: true
  }));
};

exports.Default = Default;
Default.parameters = {
  info: {
    text: "\n        For React usage, ProgressIndicator holds the currentIndex state to indicate which ProgressStep is the current step. The ProgressIndicator component should always be used with ProgressStep components as its children. Changing currentIndex prop will automatically set the ProgressStep components props (complete, incomplete, current).\n        For general usage, Progress Indicators display steps in a process. It should indicate when steps have been complete, the active step,\n        and the steps to come.\n      "
  }
};

var Interactive = function Interactive() {
  return /*#__PURE__*/_react.default.createElement(_ProgressIndicator.ProgressIndicator, {
    currentIndex: (0, _addonKnobs.number)('Current progress (currentIndex)', 1),
    onChange: (0, _addonActions.action)('onChange')
  }, /*#__PURE__*/_react.default.createElement(_ProgressIndicator.ProgressStep, {
    label: "Click me",
    description: "Step 1: Register a onChange event"
  }), /*#__PURE__*/_react.default.createElement(_ProgressIndicator.ProgressStep, {
    label: "Really long label",
    description: "The progress indicator will listen for clicks on the steps"
  }), /*#__PURE__*/_react.default.createElement(_ProgressIndicator.ProgressStep, {
    label: "Tooltip and really long label",
    description: "The progress indicator will listen for clicks on the steps",
    renderLabel: function renderLabel() {
      return /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
        direction: "bottom",
        showIcon: false,
        triggerClassName: "".concat(prefix, "--progress-label"),
        triggerText: "Tooltip and really long label",
        tooltipId: "tooltipId-1"
      }, /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor, sit amet consectetur adipisicing elit. Animi consequuntur hic ratione aliquid cupiditate, nesciunt saepe iste blanditiis cumque maxime tenetur veniam est illo deserunt sint quae pariatur. Laboriosam, consequatur."));
    }
  }));
};

exports.Interactive = Interactive;
Interactive.storyName = 'interactive';
Interactive.parameters = {
  info: {
    text: "\n       If you register an onChange handler, the Progress Indicator will become interactive.  Your parent component should update the currentIndex prop within the onChange handler.\n      "
  }
};

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement(_ProgressIndicator2.default, null);
};

exports.Skeleton = Skeleton;
Skeleton.storyName = 'skeleton';
Skeleton.parameters = {
  info: {
    text: "\n            Placeholder skeleton state to use when content is loading.\n        "
  }
};