"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.ControlledSlider = exports.Playground = exports.Default = exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Slider = _interopRequireDefault(require("../Slider"));

var _Slider2 = _interopRequireDefault(require("../Slider/Slider.Skeleton"));

var _FeatureFlags = require("../../internal/FeatureFlags");

var _Slider3 = _interopRequireDefault(require("./Slider.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var props = function props() {
  return {
    name: (0, _addonKnobs.text)('Form item name (name)', ''),
    inputType: (0, _addonKnobs.text)('The form element type (inputType)', 'number'),
    ariaLabelInput: (0, _addonKnobs.text)('The ARIA label for the <input> (ariaLabelInput)', 'Label for slider value'),
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    light: (0, _addonKnobs.boolean)('Light variant (light)', false),
    hideTextInput: (0, _addonKnobs.boolean)('Without text input (hideTextInput)', false),
    value: !_FeatureFlags.sliderValuePropSync ? 50 : (0, _addonKnobs.number)('The value (value)', 50),
    min: (0, _addonKnobs.number)('The minimum value (min)', 0),
    max: (0, _addonKnobs.number)('The maximum value (max)', 100),
    step: (0, _addonKnobs.number)('The step (step)', 1),
    stepMultiplier: (0, _addonKnobs.number)('The step factor for Shift+arrow keys (stepMultiplier)', 5),
    labelText: (0, _addonKnobs.text)('Label text (labelText)', 'Slider Label'),
    minLabel: (0, _addonKnobs.text)('Label for minimum value (minLabel)', ''),
    maxLabel: (0, _addonKnobs.text)('Label for maximum value (maxLabel)', ''),
    onChange: (0, _addonActions.action)('onChange'),
    onRelease: (0, _addonActions.action)('onRelease')
  };
};

var _default = {
  title: 'Components/Slider',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _Slider.default,
    docs: {
      page: _Slider3.default
    },
    subcomponents: {
      SliderSkeleton: _Slider2.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_Slider.default, {
    labelText: "Slider Label",
    value: 50,
    min: 30,
    max: 100,
    step: 1,
    stepMultiplier: 10,
    novalidate: true
  });
};

exports.Default = Default;
Default.story = {
  name: 'Slider'
};

var Playground = function Playground() {
  return /*#__PURE__*/_react.default.createElement(_Slider.default, _extends({
    id: "slider"
  }, props()));
};

exports.Playground = Playground;

var ControlledSlider = function ControlledSlider() {
  var _useState = (0, _react.useState)(87),
      _useState2 = _slicedToArray(_useState, 2),
      val = _useState2[0],
      setVal = _useState2[1];

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setVal(Math.round(Math.random() * 100));
    }
  }, "randomize value"), /*#__PURE__*/_react.default.createElement(_Slider.default, {
    max: 100,
    min: 0,
    value: val,
    onChange: function onChange(_ref) {
      var value = _ref.value;
      return setVal(value);
    }
  }), /*#__PURE__*/_react.default.createElement("h1", null, val));
};

exports.ControlledSlider = ControlledSlider;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement(_Slider2.default, null);
};

exports.Skeleton = Skeleton;