"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTextComponent = createTextComponent;

var _react = _interopRequireDefault(require("react"));

var _Text = require("./Text");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/**
 * Create a text component wrapper for a given text node type. Useful for
 * returning a `Text` component for a text node like a `<label>`.
 * @param {string} element
 * @param {string} displayName
 */
function createTextComponent(element, displayName) {
  function TextWrapper(props) {
    return /*#__PURE__*/_react.default.createElement(_Text.Text, _extends({
      as: element
    }, props));
  }

  if (process.env.NODE_ENV !== "production") {
    TextWrapper.displayName = displayName;
  }

  return TextWrapper;
}