"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.FullyControlledTogglePasswordVisibility = exports.TogglePasswordVisibility = exports.Fluid = exports.Default = exports.classNameChangeTest = exports.default = void 0;

var _react = _interopRequireWildcard(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _index = require("../../index");

var _TextInput = _interopRequireDefault(require("../TextInput/TextInput.Skeleton"));

var _FluidForm = _interopRequireDefault(require("../FluidForm/FluidForm"));

var _TextInput2 = _interopRequireDefault(require("./TextInput.mdx"));

var _FeatureFlags = require("../FeatureFlags");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var types = {
  None: '',
  'Text (text)': 'text',
  'For email (email)': 'email',
  'For password (password)': 'password'
};
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};

var ControlledPasswordInputApp = /*#__PURE__*/_react.default.forwardRef(function ControlledPasswordInputApp(props, ref) {
  var _useState = (0, _react.useState)('password'),
      _useState2 = _slicedToArray(_useState, 2),
      type = _useState2[0],
      setType = _useState2[1];

  var togglePasswordVisibility = function togglePasswordVisibility() {
    setType(type === 'password' ? 'text' : 'password');
  };

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_index.TextInput.PasswordInput, _extends({
    type: type,
    togglePasswordVisibility: togglePasswordVisibility,
    ref: ref
  }, props)), /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setType('text');
    }
  }, "Show password"), /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setType('password');
    }
  }, "Hide password"));
});

var props = {
  SharedInputProps: function SharedInputProps() {
    return {
      className: 'some-class',
      id: 'test2',
      defaultValue: (0, _addonKnobs.text)('Default value (defaultValue)', 'This is not a default value'),
      size: (0, _addonKnobs.select)('Field size (size)', sizes, undefined) || undefined,
      labelText: (0, _addonKnobs.text)('Label text (labelText)', 'Text input label'),
      placeholder: (0, _addonKnobs.text)('Placeholder text (placeholder)', 'Placeholder text'),
      light: (0, _addonKnobs.boolean)('Light variant (light)', false),
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
      hideLabel: (0, _addonKnobs.boolean)('No label (hideLabel)', false),
      invalid: (0, _addonKnobs.boolean)('Show form validation UI (invalid)', false),
      invalidText: (0, _addonKnobs.text)('Form validation UI content (invalidText)', 'A valid value is required'),
      warn: (0, _addonKnobs.boolean)('Show warning state (warn)', false),
      warnText: (0, _addonKnobs.text)('Warning state text (warnText)', 'This will overwrite your current settings'),
      helperText: (0, _addonKnobs.text)('Helper text (helperText)', 'Optional help text'),
      inline: (0, _addonKnobs.boolean)('Inline variant (inline)', false),
      onClick: (0, _addonActions.action)('onClick'),
      onChange: (0, _addonActions.action)('onChange')
    };
  },
  TextInputProps: function TextInputProps() {
    return {
      readOnly: (0, _addonKnobs.boolean)('Readonly variant (readOnly)', false)
    };
  },
  PasswordInputProps: function PasswordInputProps() {
    return {
      tooltipPosition: (0, _addonKnobs.select)('Tooltip position (tooltipPosition)', ['top', 'right', 'bottom', 'left'], 'bottom'),
      tooltipAlignment: (0, _addonKnobs.select)('Tooltip alignment (tooltipAlignment)', ['start', 'center', 'end'], 'center'),
      hidePasswordLabel: (0, _addonKnobs.text)('"Hide password" tooltip label for password visibility toggle (hidePasswordLabel)', 'Hide password'),
      showPasswordLabel: (0, _addonKnobs.text)('"Show password" tooltip label for password visibility toggle (showPasswordLabel)', 'Show password')
    };
  }
};
_index.TextInput.displayName = 'TextInput';
var _default = {
  title: 'Components/TextInput',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _index.TextInput,
    docs: {
      page: _TextInput2.default
    },
    subcomponents: {
      TextInputSkeleton: _TextInput.default,
      'TextInput.PasswordInput': _index.TextInput.PasswordInput
    }
  }
};
exports.default = _default;

var classNameChangeTest = function classNameChangeTest() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_index.TextInput, _extends({
    defaultValue: "The class should be added to the label",
    labelText: "Text input label",
    helperText: "Optional help text",
    type: (0, _addonKnobs.select)('Form control type (type)', types, 'text')
  }, props.TextInputProps(), {
    className: "TEST_CLASS"
  })), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_FeatureFlags.FeatureFlags, {
    flags: {
      'enable-v11-release': true
    }
  }, /*#__PURE__*/_react.default.createElement(_index.TextInput, _extends({
    defaultValue: "The class should be added to the wrapper",
    labelText: "Text input label",
    helperText: "Optional help text",
    type: (0, _addonKnobs.select)('Form control type (type)', types, 'text')
  }, props.TextInputProps(), {
    className: "TEST_CLASS"
  }))));
};

exports.classNameChangeTest = classNameChangeTest;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_index.TextInput, _extends({
    type: (0, _addonKnobs.select)('Form control type (type)', types, 'text')
  }, props.SharedInputProps(), props.TextInputProps()));
};

exports.Default = Default;
Default.parameters = {
  info: {
    text: "\n        Text fields enable the user to interact with and input data. A single line\n        field is used when the input anticipated by the user is a single line of\n        text as opposed to a paragraph.\n        The default type is 'text' and its value can be either 'string' or 'number'.\n      "
  }
};

var Fluid = function Fluid() {
  return /*#__PURE__*/_react.default.createElement(_FluidForm.default, null, /*#__PURE__*/_react.default.createElement(_index.TextInput, _extends({
    type: (0, _addonKnobs.select)('Form control type (type)', types, 'text')
  }, props.SharedInputProps(), props.TextInputProps())));
};

exports.Fluid = Fluid;
Fluid.parameters = {
  info: {
    text: "\n        Text fields enable the user to interact with and input data. A single line\n        field is used when the input anticipated by the user is a single line of\n        text as opposed to a paragraph.\n        The default type is 'text' and its value can be either 'string' or 'number'.\n      "
  }
};

var TogglePasswordVisibility = function TogglePasswordVisibility() {
  return /*#__PURE__*/_react.default.createElement(_index.TextInput.PasswordInput, _extends({}, props.SharedInputProps(), props.PasswordInputProps()));
};

exports.TogglePasswordVisibility = TogglePasswordVisibility;
TogglePasswordVisibility.storyName = 'Toggle password visibility';
TogglePasswordVisibility.parameters = {
  info: {
    text: "\n      Text field with password visibility toggle.\n    "
  }
};

var FullyControlledTogglePasswordVisibility = function FullyControlledTogglePasswordVisibility() {
  ControlledPasswordInputApp.__docgenInfo = _objectSpread(_objectSpread({}, _index.TextInput.PasswordInput.__docgenInfo), {}, {
    props: _objectSpread({}, _index.TextInput.PasswordInput.__docgenInfo.props)
  });
  return /*#__PURE__*/_react.default.createElement(ControlledPasswordInputApp, _extends({}, props.SharedInputProps(), props.PasswordInputProps()));
};

exports.FullyControlledTogglePasswordVisibility = FullyControlledTogglePasswordVisibility;
FullyControlledTogglePasswordVisibility.storyName = 'Fully controlled toggle password visibility';
FullyControlledTogglePasswordVisibility.parameters = {
  info: {
    text: "\n    Fully controlled text field with password visibility toggle.\n  "
  }
};

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement(_TextInput.default, null);
};

exports.Skeleton = Skeleton;
Skeleton.storyName = 'skeleton';
Skeleton.parameters = {
  info: {
    text: "\n        Placeholder skeleton state to use when content is loading.\n        "
  }
};