"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {};
exports.default = void 0;

var _deprecateFieldOnObject = require("../../internal/deprecateFieldOnObject");

var _TextInput = require("./TextInput.Skeleton");

Object.keys(_TextInput).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _TextInput[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _TextInput[key];
    }
  });
});

var _ControlledPasswordInput = _interopRequireDefault(require("./ControlledPasswordInput"));

var _PasswordInput = _interopRequireDefault(require("./PasswordInput"));

var _TextInput2 = _interopRequireDefault(require("./TextInput"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
_TextInput2.default.ControlledPasswordInput = _ControlledPasswordInput.default;
_TextInput2.default.PasswordInput = _PasswordInput.default;

if (process.env.NODE_ENV !== "production") {
  (0, _deprecateFieldOnObject.deprecateFieldOnObject)(_TextInput2.default, 'ControlledPasswordInput', _ControlledPasswordInput.default);
  (0, _deprecateFieldOnObject.deprecateFieldOnObject)(_TextInput2.default, 'PasswordInput', _PasswordInput.default);
}

var _default = _TextInput2.default;
exports.default = _default;