"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectableTile = SelectableTile;
exports.TileBelowTheFoldContent = exports.TileAboveTheFoldContent = exports.ExpandableTile = exports.ClickableTile = exports.Tile = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _Link = _interopRequireDefault(require("../Link"));

var _iconsReact = require("@carbon/icons-react");

var _keyboard = require("../../internal/keyboard");

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _events = require("../../tools/events");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["children", "className", "light"],
    _excluded2 = ["children", "href", "className", "handleClick", "handleKeyDown", "onClick", "onKeyDown", "clicked", "light"],
    _excluded3 = ["children", "id", "tabIndex", "value", "name", "title", "iconDescription", "className", "handleClick", "handleKeyDown", "onClick", "onChange", "onKeyDown", "light", "disabled", "selected"],
    _excluded4 = ["tabIndex", "className", "expanded", "tileMaxHeight", "tilePadding", "handleClick", "onClick", "onKeyUp", "tileCollapsedIconText", "tileExpandedIconText", "tileCollapsedLabel", "tileExpandedLabel", "onBeforeClick", "light"];

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { var _i = arr == null ? null : typeof Symbol !== "undefined" && arr[Symbol.iterator] || arr["@@iterator"]; if (_i == null) return; var _arr = []; var _n = true; var _d = false; var _s, _e; try { for (_i = _i.call(arr); !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var Tile = /*#__PURE__*/function (_Component) {
  _inherits(Tile, _Component);

  var _super = _createSuper(Tile);

  function Tile() {
    _classCallCheck(this, Tile);

    return _super.apply(this, arguments);
  }

  _createClass(Tile, [{
    key: "render",
    value: function render() {
      var prefix = this.context;

      var _this$props = this.props,
          children = _this$props.children,
          className = _this$props.className,
          light = _this$props.light,
          rest = _objectWithoutProperties(_this$props, _excluded);

      var tileClasses = (0, _classnames.default)("".concat(prefix, "--tile"), _defineProperty({}, "".concat(prefix, "--tile--light"), light), className);
      return /*#__PURE__*/_react.default.createElement("div", _extends({
        className: tileClasses
      }, rest), children);
    }
  }]);

  return Tile;
}(_react.Component);

exports.Tile = Tile;

_defineProperty(Tile, "propTypes", {
  /**
   * The child nodes.
   */
  children: _propTypes.default.node,

  /**
   * The CSS class names.
   */
  className: _propTypes.default.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: _propTypes.default.bool
});

_defineProperty(Tile, "contextType", _usePrefix.PrefixContext);

_defineProperty(Tile, "defaultProps", {
  light: false
});

var ClickableTile = /*#__PURE__*/function (_Component2) {
  _inherits(ClickableTile, _Component2);

  var _super2 = _createSuper(ClickableTile);

  function ClickableTile() {
    var _this;

    _classCallCheck(this, ClickableTile);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super2.call.apply(_super2, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {});

    _defineProperty(_assertThisInitialized(_this), "handleClick", function (evt) {
      evt.persist();

      _this.setState({
        clicked: !_this.state.clicked
      }, function () {
        var _this$props$handleCli, _this$props2, _this$props$onClick, _this$props3;

        // TODO: Remove handleClick prop when handleClick is deprecated
        ((_this$props$handleCli = (_this$props2 = _this.props).handleClick) === null || _this$props$handleCli === void 0 ? void 0 : _this$props$handleCli.call(_this$props2, evt)) || ((_this$props$onClick = (_this$props3 = _this.props).onClick) === null || _this$props$onClick === void 0 ? void 0 : _this$props$onClick.call(_this$props3, evt));
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleKeyDown", function (evt) {
      evt.persist();

      if ((0, _keyboard.matches)(evt, [_keyboard.keys.Enter, _keyboard.keys.Space])) {
        _this.setState({
          clicked: !_this.state.clicked
        }, function () {
          var _this$props$handleKey, _this$props4;

          // TODO: Remove handleKeyDown prop when handleKeyDown is deprecated
          ((_this$props$handleKey = (_this$props4 = _this.props).handleKeyDown) === null || _this$props$handleKey === void 0 ? void 0 : _this$props$handleKey.call(_this$props4, evt)) || _this.props.onKeyDown(evt);
        });
      } else {
        var _this$props$handleKey2, _this$props5;

        // TODO: Remove handleKeyDown prop when handleKeyDown is deprecated
        ((_this$props$handleKey2 = (_this$props5 = _this.props).handleKeyDown) === null || _this$props$handleKey2 === void 0 ? void 0 : _this$props$handleKey2.call(_this$props5, evt)) || _this.props.onKeyDown(evt);
      }
    });

    return _this;
  }

  _createClass(ClickableTile, [{
    key: "render",
    value: function render() {
      var _cx2;

      var prefix = this.context;

      var _this$props6 = this.props,
          children = _this$props6.children,
          href = _this$props6.href,
          className = _this$props6.className,
          handleClick = _this$props6.handleClick,
          handleKeyDown = _this$props6.handleKeyDown,
          onClick = _this$props6.onClick,
          onKeyDown = _this$props6.onKeyDown,
          clicked = _this$props6.clicked,
          light = _this$props6.light,
          rest = _objectWithoutProperties(_this$props6, _excluded2);

      var classes = (0, _classnames.default)("".concat(prefix, "--tile"), "".concat(prefix, "--tile--clickable"), (_cx2 = {}, _defineProperty(_cx2, "".concat(prefix, "--tile--is-clicked"), this.state.clicked), _defineProperty(_cx2, "".concat(prefix, "--tile--light"), light), _cx2), className);
      return /*#__PURE__*/_react.default.createElement(_Link.default, _extends({
        href: href,
        className: classes
      }, rest, {
        onClick: this.handleClick,
        onKeyDown: this.handleKeyDown
      }), children);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: // eslint-disable-next-line react/prop-types
    function getDerivedStateFromProps(_ref, state) {
      var clicked = _ref.clicked;
      var prevClicked = state.prevClicked;
      return prevClicked === clicked ? null : {
        clicked: clicked,
        prevClicked: clicked
      };
    }
  }]);

  return ClickableTile;
}(_react.Component);

exports.ClickableTile = ClickableTile;

_defineProperty(ClickableTile, "propTypes", {
  /**
   * The child nodes.
   */
  children: _propTypes.default.node,

  /**
   * The CSS class names.
   */
  className: _propTypes.default.string,

  /**
   * Deprecated in v11. Use 'onClick' instead.
   */
  handleClick: (0, _deprecate.default)(_propTypes.default.func, 'The handleClick prop for ClickableTile has been deprecated in favor of onClick. It will be removed in the next major release.'),

  /**
   * Specify the function to run when the ClickableTile is interacted with via a keyboard
   */
  handleKeyDown: (0, _deprecate.default)(_propTypes.default.func, 'The handleKeyDown prop for ClickableTile has been deprecated in favor of onKeyDown. It will be removed in the next major release.'),

  /**
   * The href for the link.
   */
  href: _propTypes.default.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: _propTypes.default.bool,

  /**
   * Specify the function to run when the ClickableTile is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Specify the function to run when the ClickableTile is interacted with via a keyboard
   */
  onKeyDown: _propTypes.default.func,

  /**
   * The rel property for the link.
   */
  rel: _propTypes.default.string
});

_defineProperty(ClickableTile, "contextType", _usePrefix.PrefixContext);

_defineProperty(ClickableTile, "defaultProps", {
  clicked: false,
  onClick: function onClick() {},
  onKeyDown: function onKeyDown() {},
  light: false
});

function SelectableTile(props) {
  var _cx3;

  var children = props.children,
      id = props.id,
      tabIndex = props.tabIndex,
      value = props.value,
      name = props.name,
      title = props.title,
      iconDescription = props.iconDescription,
      className = props.className,
      handleClick = props.handleClick,
      handleKeyDown = props.handleKeyDown,
      onClick = props.onClick,
      onChange = props.onChange,
      onKeyDown = props.onKeyDown,
      light = props.light,
      disabled = props.disabled,
      selected = props.selected,
      rest = _objectWithoutProperties(props, _excluded3);

  var prefix = (0, _usePrefix.usePrefix)(); // TODO: replace with onClick when handleClick prop is deprecated

  var clickHandler = handleClick || onClick; // TODO: replace with onKeyDown when handleKeyDown prop is deprecated

  var keyDownHandler = handleKeyDown || onKeyDown;

  var _useState = (0, _react.useState)(selected),
      _useState2 = _slicedToArray(_useState, 2),
      isSelected = _useState2[0],
      setIsSelected = _useState2[1];

  var input = (0, _react.useRef)(null);
  var classes = (0, _classnames.default)("".concat(prefix, "--tile"), "".concat(prefix, "--tile--selectable"), (_cx3 = {}, _defineProperty(_cx3, "".concat(prefix, "--tile--is-selected"), isSelected), _defineProperty(_cx3, "".concat(prefix, "--tile--light"), light), _defineProperty(_cx3, "".concat(prefix, "--tile--disabled"), disabled), _cx3), className);
  var inputClasses = (0, _classnames.default)("".concat(prefix, "--tile-input"), _defineProperty({}, "".concat(prefix, "--tile-input--checked"), isSelected)); // TODO: rename to handleClick when handleClick prop is deprecated

  function handleOnClick(evt) {
    evt.preventDefault();
    evt.persist();
    setIsSelected(!isSelected);
    clickHandler(evt);
    onChange(evt);
  } // TODO: rename to handleKeyDown when handleKeyDown prop is deprecated


  function handleOnKeyDown(evt) {
    evt.persist();

    if ((0, _keyboard.matches)(evt, [_keyboard.keys.Enter, _keyboard.keys.Space])) {
      evt.preventDefault();
      setIsSelected(!isSelected);
      onChange(evt);
    }

    keyDownHandler(evt);
  }

  function handleChange(event) {
    setIsSelected(event.target.checked);
    onChange(event);
  }

  (0, _react.useEffect)(function () {
    setIsSelected(selected);
  }, [selected]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("input", {
    ref: input,
    tabIndex: -1,
    id: id,
    className: inputClasses,
    value: value,
    onChange: !disabled ? handleChange : null,
    type: "checkbox",
    disabled: disabled,
    name: name,
    title: title,
    checked: isSelected
  }), /*#__PURE__*/_react.default.createElement("label", _extends({
    htmlFor: id,
    className: classes // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
    ,
    tabIndex: !disabled ? tabIndex : null
  }, rest, {
    onClick: !disabled ? handleOnClick : null,
    onKeyDown: !disabled ? handleOnKeyDown : null
  }), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--tile__checkmark ").concat(prefix, "--tile__checkmark--persistent")
  }, isSelected ? /*#__PURE__*/_react.default.createElement(_iconsReact.CheckboxCheckedFilled16, null) : /*#__PURE__*/_react.default.createElement(_iconsReact.Checkbox16, null)), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--tile-content")
  }, children)));
}

SelectableTile.defaultProps = {
  value: 'value',
  title: 'title',
  selected: false,
  tabIndex: 0,
  light: false,
  onClick: function onClick() {},
  onChange: function onChange() {},
  onKeyDown: function onKeyDown() {}
};
SelectableTile.propTypes = {
  /**
   * The child nodes.
   */
  children: _propTypes.default.node,

  /**
   * The CSS class names.
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the SelectableTile should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify the function to run when the SelectableTile is clicked
   */
  handleClick: (0, _deprecate.default)(_propTypes.default.func, 'The `handleClick` prop for `SelectableTile` has been deprecated in favor of `onClick`. It will be removed in the next major release.'),

  /**
   * Specify the function to run when the SelectableTile is interacted with via a keyboard
   */
  handleKeyDown: (0, _deprecate.default)(_propTypes.default.func, 'The `handleKeyDown` prop for `SelectableTile` has been deprecated in favor of `onKeyDown`. It will be removed in the next major release.'),

  /**
   * The description of the checkmark icon.
   */
  iconDescription: (0, _deprecate.default)(_propTypes.default.string, 'The `iconDescription` prop for `SelectableTile` is no longer needed and has ' + 'been deprecated. It will be removed in the next major release.'),

  /**
   * The ID of the `<input>`.
   */
  id: _propTypes.default.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: _propTypes.default.bool,

  /**
   * The `name` of the `<input>`.
   */
  name: _propTypes.default.string,

  /**
   * The empty handler of the `<input>`.
   */
  onChange: _propTypes.default.func,

  /**
   * Specify the function to run when the SelectableTile is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Specify the function to run when the SelectableTile is interacted with via a keyboard
   */
  onKeyDown: _propTypes.default.func,

  /**
   * `true` to select this tile.
   */
  selected: _propTypes.default.bool,

  /**
   * Specify the tab index of the wrapper element
   */
  tabIndex: _propTypes.default.number,

  /**
   * The `title` of the `<input>`.
   */
  title: _propTypes.default.string,

  /**
   * The value of the `<input>`.
   */
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]).isRequired
};

var ExpandableTile = /*#__PURE__*/function (_Component3) {
  _inherits(ExpandableTile, _Component3);

  var _super3 = _createSuper(ExpandableTile);

  function ExpandableTile() {
    var _this2;

    _classCallCheck(this, ExpandableTile);

    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    _this2 = _super3.call.apply(_super3, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this2), "state", {});

    _defineProperty(_assertThisInitialized(_this2), "componentDidMount", function () {
      if (_this2.tile) {
        var getStyle = window.getComputedStyle(_this2.tile, null);

        if (_this2.aboveTheFold) {
          _this2.setState({
            tileMaxHeight: _this2.aboveTheFold.getBoundingClientRect().height,
            tilePadding: parseInt(getStyle.getPropertyValue('padding-top'), 10) + parseInt(getStyle.getPropertyValue('padding-bottom'), 10)
          });
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this2), "componentDidUpdate", function (prevProps) {
      if (prevProps.expanded !== _this2.props.expanded) {
        _this2.setMaxHeight();
      }
    });

    _defineProperty(_assertThisInitialized(_this2), "setMaxHeight", function () {
      if (_this2.state.expanded ? _this2.tileContent : _this2.aboveTheFold) {
        _this2.setState({
          tileMaxHeight: _this2.state.expanded ? _this2.tileContent.getBoundingClientRect().height : _this2.aboveTheFold.getBoundingClientRect().height
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this2), "handleClick", function (evt) {
      if (!_this2.props.onBeforeClick(evt) || evt.target.tagName === 'INPUT') {
        return;
      }

      evt.persist();

      _this2.setState({
        expanded: !_this2.state.expanded
      }, function () {
        var _this2$props$handleCl, _this2$props, _this2$props$onClick, _this2$props2;

        _this2.setMaxHeight(); // TODO: Remove handleClick prop when handleClick is deprecated


        ((_this2$props$handleCl = (_this2$props = _this2.props).handleClick) === null || _this2$props$handleCl === void 0 ? void 0 : _this2$props$handleCl.call(_this2$props, evt)) || ((_this2$props$onClick = (_this2$props2 = _this2.props).onClick) === null || _this2$props$onClick === void 0 ? void 0 : _this2$props$onClick.call(_this2$props2, evt));
      });
    });

    _defineProperty(_assertThisInitialized(_this2), "handleKeyUp", function (evt) {
      if (evt.target !== _this2.tile) {
        if ((0, _keyboard.matches)(evt, [_keyboard.keys.Enter, _keyboard.keys.Space])) {
          evt.preventDefault();
        }
      }
    });

    _defineProperty(_assertThisInitialized(_this2), "getChildren", function () {
      return _react.default.Children.toArray(_this2.props.children);
    });

    return _this2;
  }

  _createClass(ExpandableTile, [{
    key: "render",
    value: function render() {
      var _cx5,
          _this3 = this;

      var _this$props7 = this.props,
          tabIndex = _this$props7.tabIndex,
          className = _this$props7.className,
          expanded = _this$props7.expanded,
          tileMaxHeight = _this$props7.tileMaxHeight,
          tilePadding = _this$props7.tilePadding,
          handleClick = _this$props7.handleClick,
          onClick = _this$props7.onClick,
          onKeyUp = _this$props7.onKeyUp,
          tileCollapsedIconText = _this$props7.tileCollapsedIconText,
          tileExpandedIconText = _this$props7.tileExpandedIconText,
          tileCollapsedLabel = _this$props7.tileCollapsedLabel,
          tileExpandedLabel = _this$props7.tileExpandedLabel,
          onBeforeClick = _this$props7.onBeforeClick,
          light = _this$props7.light,
          rest = _objectWithoutProperties(_this$props7, _excluded4);

      var prefix = this.context;
      var isExpanded = this.state.expanded;
      var classes = (0, _classnames.default)("".concat(prefix, "--tile"), "".concat(prefix, "--tile--expandable"), (_cx5 = {}, _defineProperty(_cx5, "".concat(prefix, "--tile--is-expanded"), isExpanded), _defineProperty(_cx5, "".concat(prefix, "--tile--light"), light), _cx5), className);
      var tileStyle = {
        maxHeight: isExpanded ? null : this.state.tileMaxHeight + this.state.tilePadding
      };
      var childrenAsArray = this.getChildren();
      return (
        /*#__PURE__*/
        // eslint-disable-next-line jsx-a11y/click-events-have-key-events,jsx-a11y/no-static-element-interactions
        _react.default.createElement("button", _extends({
          type: "button",
          ref: function ref(tile) {
            _this3.tile = tile;
          },
          style: tileStyle,
          className: classes,
          "aria-expanded": isExpanded,
          title: isExpanded ? tileExpandedIconText : tileCollapsedIconText
        }, rest, {
          onKeyUp: (0, _events.composeEventHandlers)([onKeyUp, this.handleKeyUp]),
          onClick: (0, _events.composeEventHandlers)([onClick, this.handleClick]),
          tabIndex: tabIndex
        }), /*#__PURE__*/_react.default.createElement("div", {
          ref: function ref(tileContent) {
            _this3.tileContent = tileContent;
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          ref: function ref(aboveTheFold) {
            _this3.aboveTheFold = aboveTheFold;
          },
          className: "".concat(prefix, "--tile-content")
        }, childrenAsArray[0]), /*#__PURE__*/_react.default.createElement("div", {
          className: "".concat(prefix, "--tile__chevron")
        }, /*#__PURE__*/_react.default.createElement("span", null, isExpanded ? tileExpandedLabel : tileCollapsedLabel), /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronDown16, null)), /*#__PURE__*/_react.default.createElement("div", {
          className: "".concat(prefix, "--tile-content")
        }, childrenAsArray[1])))
      );
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps( // eslint-disable-next-line react/prop-types
    _ref2, state) {
      var expanded = _ref2.expanded,
          tileMaxHeight = _ref2.tileMaxHeight,
          tilePadding = _ref2.tilePadding;
      var prevExpanded = state.prevExpanded,
          prevTileMaxHeight = state.prevTileMaxHeight,
          prevTilePadding = state.prevTilePadding,
          currentExpanded = state.expanded,
          currentTileMaxHeight = state.tileMaxHeight,
          currentTilePadding = state.tilePadding;
      var expandedChanged = prevExpanded !== expanded;
      var tileMaxHeightChanged = prevTileMaxHeight !== tileMaxHeight;
      var tilePaddingChanged = prevTilePadding !== tilePadding;
      return !expandedChanged && !tileMaxHeightChanged && !tilePaddingChanged ? null : {
        expanded: !expandedChanged ? currentExpanded : expanded,
        tileMaxHeight: !tileMaxHeightChanged ? currentTileMaxHeight : tileMaxHeight,
        tilePadding: !tilePaddingChanged ? currentTilePadding : tilePadding,
        prevExpanded: expanded,
        prevTileMaxHeight: tileMaxHeight,
        prevTilePadding: tilePadding
      };
    }
  }]);

  return ExpandableTile;
}(_react.Component);

exports.ExpandableTile = ExpandableTile;

_defineProperty(ExpandableTile, "propTypes", {
  /**
   * The child nodes.
   */
  children: _propTypes.default.node,

  /**
   * The CSS class names.
   */
  className: _propTypes.default.string,

  /**
   * `true` if the tile is expanded.
   */
  expanded: _propTypes.default.bool,

  /**
   * Deprecated in v11. Use 'onClick' instead.
   */
  handleClick: (0, _deprecate.default)(_propTypes.default.func, 'The handleClick prop for ClickableTile has been deprecated in favor of onClick. It will be removed in the next major release.'),

  /**
   * An ID that can be provided to aria-labelledby
   */
  id: _propTypes.default.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: _propTypes.default.bool,

  /**
   * optional handler to decide whether to ignore a click. returns false if click should be ignored
   */
  onBeforeClick: _propTypes.default.func,

  /**
   * Specify the function to run when the ExpandableTile is clicked
    */
  onClick: _propTypes.default.func,

  /**
   * optional handler to trigger a function when a key is pressed
   */
  onKeyUp: _propTypes.default.func,

  /**
   * The `tabindex` attribute.
   */
  tabIndex: _propTypes.default.number,

  /**
   * The description of the "collapsed" icon that can be read by screen readers.
   */
  tileCollapsedIconText: _propTypes.default.string,

  /**
   * When "collapsed", a label to appear next to the chevron (e.g., "View more").
   */
  tileCollapsedLabel: _propTypes.default.string,

  /**
   * The description of the "expanded" icon that can be read by screen readers.
   */
  tileExpandedIconText: _propTypes.default.string,

  /**
   * When "expanded", a label to appear next to the chevron (e.g., "View less").
   */
  tileExpandedLabel: _propTypes.default.string
});

_defineProperty(ExpandableTile, "contextType", _usePrefix.PrefixContext);

_defineProperty(ExpandableTile, "defaultProps", {
  tabIndex: 0,
  expanded: false,
  tileMaxHeight: 0,
  tilePadding: 0,
  onBeforeClick: function onBeforeClick() {
    return true;
  },
  onClick: function onClick() {},
  tileCollapsedIconText: 'Interact to expand Tile',
  tileExpandedIconText: 'Interact to collapse Tile',
  light: false
});

var TileAboveTheFoldContent = /*#__PURE__*/function (_Component4) {
  _inherits(TileAboveTheFoldContent, _Component4);

  var _super4 = _createSuper(TileAboveTheFoldContent);

  function TileAboveTheFoldContent() {
    _classCallCheck(this, TileAboveTheFoldContent);

    return _super4.apply(this, arguments);
  }

  _createClass(TileAboveTheFoldContent, [{
    key: "render",
    value: function render() {
      var prefix = this.context;
      var children = this.props.children;
      return /*#__PURE__*/_react.default.createElement("span", {
        className: "".concat(prefix, "--tile-content__above-the-fold")
      }, children);
    }
  }]);

  return TileAboveTheFoldContent;
}(_react.Component);

exports.TileAboveTheFoldContent = TileAboveTheFoldContent;

_defineProperty(TileAboveTheFoldContent, "propTypes", {
  /**
   * The child nodes.
   */
  children: _propTypes.default.node
});

_defineProperty(TileAboveTheFoldContent, "contextType", _usePrefix.PrefixContext);

var TileBelowTheFoldContent = /*#__PURE__*/function (_Component5) {
  _inherits(TileBelowTheFoldContent, _Component5);

  var _super5 = _createSuper(TileBelowTheFoldContent);

  function TileBelowTheFoldContent() {
    _classCallCheck(this, TileBelowTheFoldContent);

    return _super5.apply(this, arguments);
  }

  _createClass(TileBelowTheFoldContent, [{
    key: "render",
    value: function render() {
      var children = this.props.children;
      var prefix = this.context;
      return /*#__PURE__*/_react.default.createElement("span", {
        className: "".concat(prefix, "--tile-content__below-the-fold")
      }, children);
    }
  }]);

  return TileBelowTheFoldContent;
}(_react.Component);

exports.TileBelowTheFoldContent = TileBelowTheFoldContent;

_defineProperty(TileBelowTheFoldContent, "propTypes", {
  /**
   * The child nodes.
   */
  children: _propTypes.default.node
});

_defineProperty(TileBelowTheFoldContent, "contextType", _usePrefix.PrefixContext);