"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _TimePicker = _interopRequireDefault(require("../TimePicker"));

var _TimePickerSelect = _interopRequireDefault(require("../TimePickerSelect"));

var _SelectItem = _interopRequireDefault(require("../SelectItem"));

var _TimePicker2 = _interopRequireDefault(require("./TimePicker.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var props = {
  timepicker: function timepicker() {
    return {
      pattern: (0, _addonKnobs.text)('Regular expression for the value (pattern in <TimePicker>)', '(1[012]|[1-9]):[0-5][0-9](\\s)?'),
      placeholder: (0, _addonKnobs.text)('Placeholder text (placeholder in <TimePicker>)', 'hh:mm'),
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled in <TimePicker>)', false),
      light: (0, _addonKnobs.boolean)('Light variant (light in <TimePicker>)', false),
      labelText: (0, _addonKnobs.text)('Label text (labelText in <TimePicker>)', 'Select a time'),
      invalid: (0, _addonKnobs.boolean)('Show form validation UI (invalid in <TimePicker>)', false),
      invalidText: (0, _addonKnobs.text)('Form validation UI content (invalidText in <TimePicker>)', 'A valid value is required'),
      maxLength: (0, _addonKnobs.number)('Maximum length (maxLength in <TimePicker>)', 5),
      size: (0, _addonKnobs.select)('Field size (size)', sizes, undefined) || undefined,
      onClick: (0, _addonActions.action)('onClick'),
      onChange: (0, _addonActions.action)('onChange'),
      onBlur: (0, _addonActions.action)('onBlur')
    };
  },
  select: function select() {
    return {
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled in <TimePickerSelect>)', false),
      labelText: (0, _addonKnobs.text)('Label text (labelText in <TimePickerSelect>)', 'Please select'),
      iconDescription: (0, _addonKnobs.text)('Trigger icon description (iconDescription in <TimePickerSelect>)', 'open list of options')
    };
  }
};
var _default = {
  title: 'Components/TimePicker',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _TimePicker.default,
    docs: {
      page: _TimePicker2.default
    },
    subcomponents: {
      TimePickerSelect: _TimePickerSelect.default,
      SelectItem: _SelectItem.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  var selectProps = props.select();
  return /*#__PURE__*/_react.default.createElement(_TimePicker.default, _extends({
    id: "time-picker"
  }, props.timepicker()), /*#__PURE__*/_react.default.createElement(_TimePickerSelect.default, _extends({
    id: "time-picker-select-1"
  }, selectProps), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "AM",
    text: "AM"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "PM",
    text: "PM"
  })), /*#__PURE__*/_react.default.createElement(_TimePickerSelect.default, _extends({
    id: "time-picker-select-2"
  }, selectProps), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "Time zone 1",
    text: "Time zone 1"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "Time zone 2",
    text: "Time zone 2"
  })));
};

exports.Default = Default;
Default.parameters = {
  info: {
    text: "\n        The time picker allow users to select a time.\n      "
  }
};