"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Playground = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Toggle = _interopRequireDefault(require("../Toggle"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined
};

var toggleProps = function toggleProps() {
  return {
    labelText: (0, _addonKnobs.text)('Label toggle input control (labelText)', 'Toggle element label'),
    className: 'some-class',
    labelA: (0, _addonKnobs.text)('Label for untoggled state (labelA)', 'Off'),
    labelB: (0, _addonKnobs.text)('Label for toggled state (labelB)', 'On'),
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    onChange: (0, _addonActions.action)('onChange'),
    onToggle: (0, _addonActions.action)('onToggle'),
    size: (0, _addonKnobs.select)('Field size (size)', sizes, undefined) || undefined
  };
};

var _default = {
  title: 'Components/Toggle',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _Toggle.default,
    subcomponents: {}
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Toggle.default, {
    labelText: "Toggle (md)",
    size: "md",
    labelA: "Off",
    labelB: "On",
    defaultToggled: true,
    className: "some-class",
    id: "toggle-1"
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_Toggle.default, {
    labelText: "Toggle (sm)",
    size: "sm",
    defaultToggled: true,
    className: "some-class",
    id: "toggle-2"
  }));
};

exports.Default = Default;

var Playground = function Playground() {
  return /*#__PURE__*/_react.default.createElement(_Toggle.default, _extends({
    defaultToggled: true
  }, toggleProps(), {
    className: "some-class",
    id: "toggle-3"
  }));
};

exports.Playground = Playground;
Default.storyName = 'Toggle';