"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Playground = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _iconsReact = require("@carbon/icons-react");

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _TooltipIcon = _interopRequireDefault(require("../TooltipIcon"));

var _TooltipIcon2 = _interopRequireDefault(require("./TooltipIcon.mdx"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var directions = {
  'Top (top)': 'top',
  'Right (right)': 'right',
  'Bottom (bottom)': 'bottom',
  'Left (left)': 'left'
};
var alignments = {
  'Start (start)': 'start',
  'Center (center)': 'center',
  'End (end)': 'end'
};
var icons = {
  'Add (Add16 from `@carbon/icons-react`)': 'Add16',
  'Add (Filled) (AddFilled16 from `@carbon/icons-react`)': 'AddFilled16',
  'Filter (Filter16 from `@carbon/icons-react`)': 'Filter16',
  'Search (Search16 from `@carbon/icons-react`)': 'Search16'
};
var iconMap = {
  Add16: _iconsReact.Add16,
  AddFilled16: _iconsReact.AddFilled16,
  Filter16: _iconsReact.Filter16,
  Search16: _iconsReact.Search16
};

var props = function props() {
  var iconToUse = iconMap[(0, _addonKnobs.select)('Icon (icon)', icons, 'Filter16')];
  return {
    disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false),
    direction: (0, _addonKnobs.select)('Tooltip direction (direction)', directions, 'bottom'),
    align: (0, _addonKnobs.select)('Tooltip alignment (align)', alignments, 'center'),
    renderIcon: !iconToUse || iconToUse.svgData ? undefined : iconToUse,
    tooltipText: (0, _addonKnobs.text)('Tooltip content (tooltipText)', 'Filter'),
    onClick: (0, _addonActions.action)('onClick')
  };
};

var _default = {
  title: 'Components/TooltipIcon',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _TooltipIcon.default,
    docs: {
      page: _TooltipIcon2.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: '2rem',
      display: 'flex',
      justifyContent: 'space-between',
      width: '200px'
    }
  }, /*#__PURE__*/_react.default.createElement(_TooltipIcon.default, {
    tooltipText: "Interactive tooltip",
    onClick: (0, _addonActions.action)('onClick'),
    renderIcon: _iconsReact.Filter16
  }), /*#__PURE__*/_react.default.createElement(_TooltipIcon.default, {
    tooltipText: "Non-interactive tooltip",
    renderIcon: _iconsReact.Information16
  }));
};

exports.Default = Default;

var Playground = function Playground() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: '2rem',
      display: 'flex',
      justifyContent: 'space-between',
      width: '200px'
    }
  }, /*#__PURE__*/_react.default.createElement(_TooltipIcon.default, props()));
};

exports.Playground = Playground;