"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _usePrefix = require("../../internal/usePrefix");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var SideNavIcon = function SideNavIcon(_ref) {
  var _cx;

  var children = _ref.children,
      customClassName = _ref.className,
      small = _ref.small;
  var prefix = (0, _usePrefix.usePrefix)();
  var className = (0, _classnames.default)((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--side-nav__icon"), true), _defineProperty(_cx, "".concat(prefix, "--side-nav__icon--small"), small), _defineProperty(_cx, customClassName, !!customClassName), _cx));
  return /*#__PURE__*/_react.default.createElement("div", {
    className: className
  }, children);
};

SideNavIcon.propTypes = {
  /**
   * Provide a single icon as the child to `SideNavIcon` to render in the
   * container
   */
  children: _propTypes.default.node.isRequired,

  /**
   * Provide an optional class to be applied to the containing node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the icon should be placed in a smaller bounding box
   */
  small: _propTypes.default.bool.isRequired
};
SideNavIcon.defaultProps = {
  small: false
};
var _default = SideNavIcon;
exports.default = _default;