"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _utils = require("./_utils");

var _usePrefix = require("../../internal/usePrefix");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var SideNavItems = function SideNavItems(_ref) {
  var customClassName = _ref.className,
      children = _ref.children,
      isSideNavExpanded = _ref.isSideNavExpanded;
  var prefix = (0, _usePrefix.usePrefix)();
  var className = (0, _classnames.default)(["".concat(prefix, "--side-nav__items")], customClassName);

  var childrenWithExpandedState = _react.default.Children.map(children, function (child) {
    if ( /*#__PURE__*/_react.default.isValidElement(child)) {
      var _child$type;

      // avoid spreading `isSideNavExpanded` to non-Carbon UI Shell children
      return /*#__PURE__*/_react.default.cloneElement(child, _objectSpread({}, _utils.CARBON_SIDENAV_ITEMS.includes((_child$type = child.type) === null || _child$type === void 0 ? void 0 : _child$type.displayName) ? {
        isSideNavExpanded: isSideNavExpanded
      } : {}));
    }
  });

  return /*#__PURE__*/_react.default.createElement("ul", {
    className: className
  }, childrenWithExpandedState);
};

SideNavItems.propTypes = {
  /**
   * Provide a single icon as the child to `SideNavIcon` to render in the
   * container
   */
  children: _propTypes.default.node.isRequired,

  /**
   * Provide an optional class to be applied to the containing node
   */
  className: _propTypes.default.string,

  /**
   * Property to indicate if the side nav container is open (or not). Use to
   * keep local state and styling in step with the SideNav expansion state.
   */
  isSideNavExpanded: _propTypes.default.bool
};
var _default = SideNavItems;
exports.default = _default;