"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEvent = useEvent;

var _react = require("react");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
function useEvent(element, eventName, callback) {
  var savedCallback = (0, _react.useRef)(null);
  (0, _react.useEffect)(function () {
    savedCallback.current = callback;
  });
  (0, _react.useEffect)(function () {
    function handler(event) {
      if (savedCallback.current) {
        savedCallback.current(event);
      }
    }

    element.addEventListener(eventName, handler);
    return function () {
      element.removeEventListener(eventName, handler);
    };
  }, [element, eventName]);
}