"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@kui-shell/core");

var _exec = require("./exec");

var _help = require("../../lib/util/help");

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/** is the given string `str` the `kubectl` command? */
const isKubectl = str => /^k(ubectl)?$/.test(str);

var _default = registrar => {
  if ((0, _core.inBrowser)() && !(0, _core.hasProxy)()) {
    // skipping catchall registration: in browser and no remote proxy to support it
    return;
  } //
  // if we aren't running in a browser, then pass any command not
  // found exceptions to the outer shell
  //


  registrar.catchall(argv => isKubectl(argv[0]), args => (0, _help.isUsage)(args) ? (0, _help.doHelp)('kubectl', args) : (0, _exec.doExecWithPty)(args), 1 // priority
  );
};

exports.default = _default;