"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.emitKubectlConfigChangeEvent = emitKubectlConfigChangeEvent;
exports.onKubectlConfigChangeEvents = onKubectlConfigChangeEvents;
exports.offKubectlConfigChangeEvents = offKubectlConfigChangeEvents;
exports.register = register;
exports.default = void 0;

var _core = require("@kui-shell/core");

var _flags = _interopRequireDefault(require("./flags"));

var _exec = require("./exec");

var _options = require("./options");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const kubectlConfigChangeChannel = '/kubectl/config/change';
const mutators = ['delete-cluster', 'delete-context', 'rename-context', 'set', 'set-cluster', 'set-context', 'set-credentials', 'unset', 'use-context'];

function emitKubectlConfigChangeEvent(type, namespace, context) {
  try {
    _core.eventChannelUnsafe.emit(kubectlConfigChangeChannel, type, namespace, context);
  } catch (err) {
    console.error('Error in onKubectlConfigChangeEvent handler', err);
  }
}

function onKubectlConfigChangeEvents(handler) {
  _core.eventChannelUnsafe.on(kubectlConfigChangeChannel, handler);
}

function offKubectlConfigChangeEvents(handler) {
  _core.eventChannelUnsafe.off(kubectlConfigChangeChannel, handler);
}
/**
 * Here, we conservatively broadcoast that the kubectl config *may*
 * have changed.
 *
 */


function emitChangeEventIfNeeded(args) {
  const idx = args.argvNoOptions.indexOf('config');
  const verb = args.argvNoOptions[idx + 1];
  const change = verb === 'set' || verb === 'use-context' || verb === 'set-context' && !args.parsedOptions.current ? 'NewContext' : verb === 'set-context' || verb === 'set-cluster' || verb === 'set-credentials' || verb === 'rename-context' ? 'AlteredContext' : undefined;

  if (change) {
    emitKubectlConfigChangeEvent('SetNamespaceOrContext', (0, _options.getNamespaceAsExpressed)(args), verb === 'use-context' ? args.argvNoOptions[idx + 2] : undefined);
  }
}
/** Kui proxy-side handler; we just pass it through to the PTY, and then emit a config change event */


function doConfig(args) {
  return __awaiter(this, void 0, void 0, function* () {
    args.command = args.command.replace(/_config/, 'config');
    args.argvNoOptions[1] = 'config';
    args.argv[1] = 'config';
    const response = yield (0, _exec.doExecWithPty)(args);
    emitChangeEventIfNeeded(args);
    return response;
  });
}
/** Kui client-side handler; we pass it through to the proxy-side handler, but also emit a config change event */


function doConfigClient(cmd, verb, args) {
  return __awaiter(this, void 0, void 0, function* () {
    const command = args.command.replace(/config/, '_config');
    const response = yield args.REPL.qexec(command);
    emitChangeEventIfNeeded(args);
    return response;
  });
}

function register(registrar, cmd) {
  mutators.forEach(verb => {
    registrar.listen(`/${cmd}/_config/${verb}`, doConfig, Object.assign({}, _flags.default, {
      requiresLocal: true
    }));
    registrar.listen(`/${cmd}/config/${verb}`, doConfigClient.bind(undefined, cmd, verb), _flags.default);
  });
}
/**
 * Register the commands
 *
 */


var _default = registrar => {
  register(registrar, 'kubectl');
  register(registrar, 'k');
};

exports.default = _default;